/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.encoder;

import lombok.NonNull;
import org.indunet.fastproto.annotation.type.ByteType;
import org.indunet.fastproto.encoder.EncodeContext;
import org.indunet.fastproto.encoder.TypeEncoder;
import org.indunet.fastproto.exception.EncodeException;

public class ByteEncoder
implements TypeEncoder {
    @Override
    public void encode(@NonNull EncodeContext context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        ByteType type = context.getDataType(ByteType.class);
        Byte value = context.getValue(Byte.class);
        this.encode(context.getDatagram(), type.value(), value);
    }

    public void encode(@NonNull byte[] datagram, int byteOffset, byte value) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        int n = byteOffset = byteOffset >= 0 ? byteOffset : datagram.length + byteOffset;
        if (byteOffset < 0) {
            throw new EncodeException(EncodeException.EncodeError.ILLEGAL_BYTE_OFFSET);
        }
        if (byteOffset + 1 > datagram.length) {
            throw new EncodeException(EncodeException.EncodeError.EXCEEDED_DATAGRAM_SIZE);
        }
        datagram[byteOffset] = value;
    }
}

