/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.encoder;

import java.nio.charset.Charset;
import lombok.NonNull;
import org.indunet.fastproto.annotation.type.StringType;
import org.indunet.fastproto.encoder.EncodeContext;
import org.indunet.fastproto.encoder.TypeEncoder;
import org.indunet.fastproto.exception.EncodeException;

public class StringEncoder
implements TypeEncoder {
    @Override
    public void encode(@NonNull EncodeContext context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        StringType dataType = context.getDataType(StringType.class);
        String value = context.getValue(String.class);
        this.encode(context.getDatagram(), dataType.value(), dataType.length(), Charset.defaultCharset(), value);
    }

    public void encode(@NonNull byte[] datagram, int byteOffset, int length, @NonNull Charset set, @NonNull String value) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (set == null) {
            throw new NullPointerException("set is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        int n = byteOffset = byteOffset >= 0 ? byteOffset : datagram.length + byteOffset;
        if (byteOffset < 0) {
            throw new EncodeException(EncodeException.EncodeError.ILLEGAL_BYTE_OFFSET);
        }
        if (length < -1) {
            throw new EncodeException(EncodeException.EncodeError.ILLEGAL_PARAMETER);
        }
        byte[] bytes = value.getBytes(set);
        if (length == -1 && byteOffset + bytes.length > datagram.length) {
            throw new EncodeException(EncodeException.EncodeError.EXCEEDED_DATAGRAM_SIZE);
        }
        if (length != -1 && byteOffset + length > datagram.length) {
            throw new EncodeException(EncodeException.EncodeError.EXCEEDED_DATAGRAM_SIZE);
        }
        if (length == -1) {
            System.arraycopy(bytes, 0, datagram, byteOffset, bytes.length);
        } else {
            System.arraycopy(bytes, 0, datagram, byteOffset, length);
        }
    }
}

