/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.ProtocolType;
import org.indunet.fastproto.annotation.DecodeIgnore;
import org.indunet.fastproto.annotation.Decoder;
import org.indunet.fastproto.annotation.EncodeIgnore;
import org.indunet.fastproto.annotation.Encoder;
import org.indunet.fastproto.annotation.Endian;
import org.indunet.fastproto.annotation.TypeFlag;
import org.indunet.fastproto.annotation.type.AutoType;
import org.indunet.fastproto.decoder.DecodeContext;
import org.indunet.fastproto.decoder.TypeDecoder;
import org.indunet.fastproto.encoder.EncodeContext;
import org.indunet.fastproto.encoder.TypeEncoder;
import org.indunet.fastproto.exception.CodecException;
import org.indunet.fastproto.exception.DecodeException;
import org.indunet.fastproto.exception.EncodeException;

public class TypeAssist {
    protected static final ThreadLocal<Object> instance = new ThreadLocal();
    TypeAssist parent;
    Class<?> clazz;
    Field field;
    Annotation typeAnnotation;
    EndianPolicy endianPolicy;
    Boolean decodeIgnore;
    Boolean encodeIgnore;
    ElementType elementType;
    List<TypeAssist> elements;
    Class<? extends TypeDecoder> decoderClass;
    Class<? extends TypeEncoder> encoderClass;
    Class<? extends Function> decodeFormula;
    Class<? extends Function> encodeFormula;
    Function<DecodeContext, ?> decoder;
    Consumer<?> encoder;

    protected TypeAssist() {
    }

    public static TypeAssist of(Class<?> clazz) {
        Predicate<Field> isType = f -> Arrays.stream(f.getAnnotations()).map(Annotation::annotationType).anyMatch(t -> t.isAnnotationPresent(TypeFlag.class));
        Stream<TypeAssist> typeStream = Arrays.stream(clazz.getDeclaredFields()).filter(f -> !f.isAnnotationPresent(DecodeIgnore.class) && !f.isAnnotationPresent(EncodeIgnore.class)).filter(isType.negate()).map(f -> {
            f.setAccessible(true);
            Class<?> c = f.getType();
            TypeAssist a = TypeAssist.of(c);
            Boolean decodeIgnore = f.isAnnotationPresent(DecodeIgnore.class);
            Boolean encodeIgnore = f.isAnnotationPresent(EncodeIgnore.class);
            a.setDecodeIgnore(decodeIgnore);
            a.setEncodeIgnore(encodeIgnore);
            a.setField((Field)f);
            return a;
        }).filter(TypeAssist::hasElement);
        EndianPolicy endianPolicy = Optional.ofNullable(clazz.getAnnotation(Endian.class)).map(Endian::value).orElse(EndianPolicy.LITTLE);
        Boolean decodeIgnore = clazz.isAnnotationPresent(DecodeIgnore.class);
        Boolean encodeIgnore = clazz.isAnnotationPresent(EncodeIgnore.class);
        Stream<TypeAssist> fieldStream = Arrays.stream(clazz.getDeclaredFields()).filter(f -> !f.isAnnotationPresent(DecodeIgnore.class) && !f.isAnnotationPresent(EncodeIgnore.class)).filter(isType).peek(f -> f.setAccessible(true)).map(TypeAssist::of).peek(a -> {
            if (a.getEndianPolicy() == null) {
                a.setEndianPolicy(endianPolicy);
            }
        });
        TypeAssist assist = TypeAssist.builder().clazz(clazz).field(null).typeAnnotation(null).decoderClass(null).encoderClass(null).decodeFormula(null).encodeFormula(null).endianPolicy(endianPolicy).decodeIgnore(decodeIgnore).encodeIgnore(encodeIgnore).elementType(ElementType.TYPE).build();
        List<TypeAssist> elements = Stream.concat(fieldStream, typeStream).peek(a -> a.setParent(assist)).collect(Collectors.toList());
        assist.setElements(elements);
        return assist;
    }

    protected static Class<? extends Annotation> getTypeAnnotationClass(@NonNull Field field) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        Annotation typeAnnotation = TypeAssist.getTypeAnnotation(field);
        if (typeAnnotation instanceof AutoType) {
            return ProtocolType.byAutoType(field.getType()).typeAnnotationClass;
        }
        return typeAnnotation.annotationType();
    }

    protected static Annotation getTypeAnnotation(@NonNull Field field) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        return Arrays.stream(field.getAnnotations()).filter(a -> a.annotationType().isAnnotationPresent(TypeFlag.class)).findAny().orElseThrow(CodecException::new);
    }

    protected static Annotation getProxyTypeAnnotation(@NonNull Field field) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        Annotation typeAnnotation = TypeAssist.getTypeAnnotation(field);
        if (typeAnnotation instanceof AutoType) {
            Class<? extends Annotation> typeAnnotationClass = ProtocolType.byAutoType(field.getType()).typeAnnotationClass;
            return typeAnnotationClass.cast(Proxy.newProxyInstance(ClassLoader.getSystemClassLoader(), new Class[]{typeAnnotationClass}, (object, method, parameters) -> Arrays.stream(typeAnnotation.getClass().getMethods()).filter(m -> m.getName().equals(method.getName())).findAny().orElseThrow(CodecException::new).invoke((Object)typeAnnotation, new Object[0])));
        }
        return typeAnnotation;
    }

    protected static TypeAssist of(Field field) {
        EndianPolicy policy = Optional.ofNullable(field.getAnnotation(Endian.class)).map(Endian::value).orElse(null);
        Boolean decodeIgnore = field.isAnnotationPresent(DecodeIgnore.class);
        Boolean encodeIgnore = field.isAnnotationPresent(EncodeIgnore.class);
        Class<? extends Annotation> typeAnnotationClass = TypeAssist.getTypeAnnotationClass(field);
        Annotation typeAnnotation = TypeAssist.getTypeAnnotation(field);
        Class decoder = Optional.of(typeAnnotationClass).map(t -> t.getAnnotation(Decoder.class)).map(Decoder::value).orElse(null);
        Class encoder = Optional.of(typeAnnotationClass).map(t -> t.getAnnotation(Encoder.class)).map(Encoder::value).orElse(null);
        Function<String, Class> formula = name -> {
            try {
                Method method = typeAnnotation.getClass().getMethod((String)name, new Class[0]);
                Object array = method.invoke((Object)typeAnnotation, new Object[0]);
                return Optional.of(array).filter(a -> a.getClass().isArray()).filter(a -> Array.getLength(a) >= 1).map(a -> Array.get(a, 0)).map(o -> (Class)o).orElse(null);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
                throw new DecodeException(MessageFormat.format(DecodeException.DecodeError.FAIL_GETTING_DECODE_FORMULA.getMessage(), typeAnnotation.annotationType().getName(), field.getName()), (Throwable)e);
            }
        };
        Class afterDecode = formula.apply("afterDecode");
        Class beforeEncode = formula.apply("beforeEncode");
        try {
            if (afterDecode == null && beforeEncode == null) {
                Field f = typeAnnotationClass.getField("JAVA_TYPES");
                Arrays.stream((Type[])f.get(typeAnnotation)).filter(t -> t == field.getType()).findAny().orElseThrow(() -> new CodecException(MessageFormat.format(CodecException.CodecError.ANNOTATION_FIELD_NOT_MATCH.getMessage(), typeAnnotation.annotationType().getName(), field.getName())));
            }
            if (afterDecode != null) {
                Arrays.stream(afterDecode.getGenericInterfaces()).filter(i -> i instanceof ParameterizedType).map(i -> ((ParameterizedType)i).getActualTypeArguments()).map(a -> a[1]).filter(t -> {
                    if (field.getType().isPrimitive()) {
                        return t == TypeAssist.wrapperClass(field.getType().getName());
                    }
                    return t == field.getType();
                }).findAny().orElseThrow(() -> new CodecException(MessageFormat.format(CodecException.CodecError.ANNOTATION_FIELD_NOT_MATCH.getMessage(), typeAnnotation.annotationType().getName(), field.getName())));
            }
            if (beforeEncode != null) {
                Arrays.stream(beforeEncode.getGenericInterfaces()).filter(i -> i instanceof ParameterizedType).map(i -> ((ParameterizedType)i).getActualTypeArguments()).map(a -> a[0]).filter(t -> {
                    if (field.getType().isPrimitive()) {
                        return t == TypeAssist.wrapperClass(field.getType().getName());
                    }
                    return t == field.getType();
                }).findAny().orElseThrow(() -> new CodecException(MessageFormat.format(CodecException.CodecError.ANNOTATION_FIELD_NOT_MATCH.getMessage(), typeAnnotation.annotationType().getName(), field.getName())));
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new CodecException(MessageFormat.format(CodecException.CodecError.ANNOTATION_FIELD_NOT_MATCH.getMessage(), typeAnnotation.annotationType().getName(), field.getName()), e);
        }
        return TypeAssist.builder().clazz(field.getType()).field(field).typeAnnotation(TypeAssist.getProxyTypeAnnotation(field)).decoderClass(decoder).encoderClass(encoder).decodeFormula(afterDecode).encodeFormula(beforeEncode).endianPolicy(policy).decodeIgnore(decodeIgnore).encodeIgnore(encodeIgnore).elementType(ElementType.FIELD).build();
    }

    public static Type wrapperClass(String name) {
        switch (name) {
            case "boolean": {
                return Boolean.class;
            }
            case "byte": {
                return Byte.class;
            }
            case "char": {
                return Character.class;
            }
            case "short": {
                return Short.class;
            }
            case "int": {
                return Integer.class;
            }
            case "long": {
                return Long.class;
            }
            case "float": {
                return Float.class;
            }
            case "double": {
                return Double.class;
            }
        }
        throw new CodecException(MessageFormat.format(CodecException.CodecError.UNSUPPORTED_TYPE.getMessage(), name));
    }

    public <T> T getObject(Class<T> clazz) {
        Object object = instance.get();
        instance.remove();
        return (T)object;
    }

    public boolean hasElement() {
        return this.elements != null && !this.elements.isEmpty();
    }

    public void setValue(Object object, Object value) {
        try {
            this.field.set(object, value);
        }
        catch (IllegalAccessException e) {
            throw new DecodeException(MessageFormat.format(DecodeException.DecodeError.FAIL_ASSIGN_VALUE.getMessage(), this.field.getName()), (Throwable)e);
        }
    }

    protected DecodeContext toDecodeContext(byte[] datagram, Object object) {
        return DecodeContext.builder().object(object).datagram(datagram).typeAssist(this).build();
    }

    protected List<DecodeContext> toDecodeContexts(byte[] datagram, Object parent) {
        try {
            Object value = this.clazz.newInstance();
            if (parent == null) {
                instance.set(value);
            }
            if (parent != null && this.field != null) {
                try {
                    this.field.set(parent, value);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            Stream<DecodeContext> fieldStream = this.elements.stream().filter(a -> a.getElementType() == ElementType.FIELD).map(a -> a.toDecodeContext(datagram, value));
            Stream classStream = this.elements.stream().filter(a -> a.getElementType() == ElementType.TYPE).flatMap(a -> a.toDecodeContexts(datagram, value).stream());
            return Stream.concat(fieldStream, classStream).collect(Collectors.toList());
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            throw new DecodeException(MessageFormat.format(DecodeException.DecodeError.FAIL_INITIALIZING_DECODE_OBJECT.getMessage(), this.clazz.getName()), (Throwable)e);
        }
    }

    public List<DecodeContext> toDecodeContexts(byte[] datagram) {
        return this.toDecodeContexts(datagram, null);
    }

    public EncodeContext toEncodeContext(Object object, byte[] datagram) {
        try {
            return EncodeContext.builder().datagram(datagram).typeAssist(this).value(this.field.get(object)).build();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new EncodeException(MessageFormat.format(EncodeException.EncodeError.FAIL_GETTING_FIELD_VALUE.getMessage(), this.field.getName()), (Throwable)e);
        }
    }

    public List<EncodeContext> toEncodeContexts(Object object, byte[] datagram) {
        Stream<EncodeContext> fieldStream = this.elements.stream().filter(a -> a.getElementType() == ElementType.FIELD).map(a -> a.toEncodeContext(object, datagram));
        Stream classStream = this.elements.stream().filter(a -> a.getElementType() == ElementType.TYPE).flatMap(a -> {
            try {
                if (object != null && a.field.get(object) != null) {
                    return a.toEncodeContexts(a.field.get(object), datagram).stream();
                }
                return Stream.empty();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new DecodeException(MessageFormat.format(EncodeException.EncodeError.FAIL_GETTING_FIELD_VALUE.getMessage(), this.clazz.getName()), (Throwable)e);
            }
        });
        return Stream.concat(fieldStream, classStream).filter(c -> c.getValue() != null).collect(Collectors.toList());
    }

    public static TypeAssistBuilder builder() {
        return new TypeAssistBuilder();
    }

    public TypeAssist getParent() {
        return this.parent;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public Field getField() {
        return this.field;
    }

    public Annotation getTypeAnnotation() {
        return this.typeAnnotation;
    }

    public EndianPolicy getEndianPolicy() {
        return this.endianPolicy;
    }

    public Boolean getDecodeIgnore() {
        return this.decodeIgnore;
    }

    public Boolean getEncodeIgnore() {
        return this.encodeIgnore;
    }

    public ElementType getElementType() {
        return this.elementType;
    }

    public List<TypeAssist> getElements() {
        return this.elements;
    }

    public Class<? extends TypeDecoder> getDecoderClass() {
        return this.decoderClass;
    }

    public Class<? extends TypeEncoder> getEncoderClass() {
        return this.encoderClass;
    }

    public Class<? extends Function> getDecodeFormula() {
        return this.decodeFormula;
    }

    public Class<? extends Function> getEncodeFormula() {
        return this.encodeFormula;
    }

    public Function<DecodeContext, ?> getDecoder() {
        return this.decoder;
    }

    public Consumer<?> getEncoder() {
        return this.encoder;
    }

    public void setParent(TypeAssist parent) {
        this.parent = parent;
    }

    public void setClazz(Class<?> clazz) {
        this.clazz = clazz;
    }

    public void setField(Field field) {
        this.field = field;
    }

    public void setTypeAnnotation(Annotation typeAnnotation) {
        this.typeAnnotation = typeAnnotation;
    }

    public void setEndianPolicy(EndianPolicy endianPolicy) {
        this.endianPolicy = endianPolicy;
    }

    public void setDecodeIgnore(Boolean decodeIgnore) {
        this.decodeIgnore = decodeIgnore;
    }

    public void setEncodeIgnore(Boolean encodeIgnore) {
        this.encodeIgnore = encodeIgnore;
    }

    public void setElementType(ElementType elementType) {
        this.elementType = elementType;
    }

    public void setElements(List<TypeAssist> elements) {
        this.elements = elements;
    }

    public void setDecoderClass(Class<? extends TypeDecoder> decoderClass) {
        this.decoderClass = decoderClass;
    }

    public void setEncoderClass(Class<? extends TypeEncoder> encoderClass) {
        this.encoderClass = encoderClass;
    }

    public void setDecodeFormula(Class<? extends Function> decodeFormula) {
        this.decodeFormula = decodeFormula;
    }

    public void setEncodeFormula(Class<? extends Function> encodeFormula) {
        this.encodeFormula = encodeFormula;
    }

    public void setDecoder(Function<DecodeContext, ?> decoder) {
        this.decoder = decoder;
    }

    public void setEncoder(Consumer<?> encoder) {
        this.encoder = encoder;
    }

    public TypeAssist(TypeAssist parent, Class<?> clazz, Field field, Annotation typeAnnotation, EndianPolicy endianPolicy, Boolean decodeIgnore, Boolean encodeIgnore, ElementType elementType, List<TypeAssist> elements, Class<? extends TypeDecoder> decoderClass, Class<? extends TypeEncoder> encoderClass, Class<? extends Function> decodeFormula, Class<? extends Function> encodeFormula, Function<DecodeContext, ?> decoder, Consumer<?> encoder) {
        this.parent = parent;
        this.clazz = clazz;
        this.field = field;
        this.typeAnnotation = typeAnnotation;
        this.endianPolicy = endianPolicy;
        this.decodeIgnore = decodeIgnore;
        this.encodeIgnore = encodeIgnore;
        this.elementType = elementType;
        this.elements = elements;
        this.decoderClass = decoderClass;
        this.encoderClass = encoderClass;
        this.decodeFormula = decodeFormula;
        this.encodeFormula = encodeFormula;
        this.decoder = decoder;
        this.encoder = encoder;
    }

    public static class TypeAssistBuilder {
        private TypeAssist parent;
        private Class<?> clazz;
        private Field field;
        private Annotation typeAnnotation;
        private EndianPolicy endianPolicy;
        private Boolean decodeIgnore;
        private Boolean encodeIgnore;
        private ElementType elementType;
        private List<TypeAssist> elements;
        private Class<? extends TypeDecoder> decoderClass;
        private Class<? extends TypeEncoder> encoderClass;
        private Class<? extends Function> decodeFormula;
        private Class<? extends Function> encodeFormula;
        private Function<DecodeContext, ?> decoder;
        private Consumer<?> encoder;

        TypeAssistBuilder() {
        }

        public TypeAssistBuilder parent(TypeAssist parent) {
            this.parent = parent;
            return this;
        }

        public TypeAssistBuilder clazz(Class<?> clazz) {
            this.clazz = clazz;
            return this;
        }

        public TypeAssistBuilder field(Field field) {
            this.field = field;
            return this;
        }

        public TypeAssistBuilder typeAnnotation(Annotation typeAnnotation) {
            this.typeAnnotation = typeAnnotation;
            return this;
        }

        public TypeAssistBuilder endianPolicy(EndianPolicy endianPolicy) {
            this.endianPolicy = endianPolicy;
            return this;
        }

        public TypeAssistBuilder decodeIgnore(Boolean decodeIgnore) {
            this.decodeIgnore = decodeIgnore;
            return this;
        }

        public TypeAssistBuilder encodeIgnore(Boolean encodeIgnore) {
            this.encodeIgnore = encodeIgnore;
            return this;
        }

        public TypeAssistBuilder elementType(ElementType elementType) {
            this.elementType = elementType;
            return this;
        }

        public TypeAssistBuilder elements(List<TypeAssist> elements) {
            this.elements = elements;
            return this;
        }

        public TypeAssistBuilder decoderClass(Class<? extends TypeDecoder> decoderClass) {
            this.decoderClass = decoderClass;
            return this;
        }

        public TypeAssistBuilder encoderClass(Class<? extends TypeEncoder> encoderClass) {
            this.encoderClass = encoderClass;
            return this;
        }

        public TypeAssistBuilder decodeFormula(Class<? extends Function> decodeFormula) {
            this.decodeFormula = decodeFormula;
            return this;
        }

        public TypeAssistBuilder encodeFormula(Class<? extends Function> encodeFormula) {
            this.encodeFormula = encodeFormula;
            return this;
        }

        public TypeAssistBuilder decoder(Function<DecodeContext, ?> decoder) {
            this.decoder = decoder;
            return this;
        }

        public TypeAssistBuilder encoder(Consumer<?> encoder) {
            this.encoder = encoder;
            return this;
        }

        public TypeAssist build() {
            return new TypeAssist(this.parent, this.clazz, this.field, this.typeAnnotation, this.endianPolicy, this.decodeIgnore, this.encodeIgnore, this.elementType, this.elements, this.decoderClass, this.encoderClass, this.decodeFormula, this.encodeFormula, this.decoder, this.encoder);
        }

        public String toString() {
            return "TypeAssist.TypeAssistBuilder(parent=" + this.parent + ", clazz=" + this.clazz + ", field=" + this.field + ", typeAnnotation=" + this.typeAnnotation + ", endianPolicy=" + (Object)((Object)this.endianPolicy) + ", decodeIgnore=" + this.decodeIgnore + ", encodeIgnore=" + this.encodeIgnore + ", elementType=" + (Object)((Object)this.elementType) + ", elements=" + this.elements + ", decoderClass=" + this.decoderClass + ", encoderClass=" + this.encoderClass + ", decodeFormula=" + this.decodeFormula + ", encodeFormula=" + this.encodeFormula + ", decoder=" + this.decoder + ", encoder=" + this.encoder + ")";
        }
    }
}

