/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto;

import java.util.Optional;
import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.annotation.Endian;
import org.indunet.fastproto.annotation.ProtocolVersion;
import org.indunet.fastproto.exception.DecodeException;
import org.indunet.fastproto.exception.EncodeException;
import org.indunet.fastproto.util.DecodeUtils;
import org.indunet.fastproto.util.EncodeUtils;

public class VersionAssist {
    public static boolean validate(byte[] datagram, Class<?> protocolClass) {
        if (!protocolClass.isAnnotationPresent(ProtocolVersion.class)) {
            return true;
        }
        ProtocolVersion versionAnnotation = protocolClass.getAnnotation(ProtocolVersion.class);
        int i = VersionAssist.decode(datagram, protocolClass);
        return versionAnnotation.version() == i;
    }

    public static int decode(byte[] datagram, Class<?> protocolClass) {
        if (!protocolClass.isAnnotationPresent(ProtocolVersion.class)) {
            return -1;
        }
        ProtocolVersion versionAnnotation = protocolClass.getAnnotation(ProtocolVersion.class);
        EndianPolicy policy = Optional.ofNullable(protocolClass.getAnnotation(Endian.class)).map(Endian::value).orElse(EndianPolicy.LITTLE);
        int byteOffset = versionAnnotation.value();
        switch (versionAnnotation.protocolType()) {
            case UINTEGER8: {
                return DecodeUtils.uInteger8Type(datagram, byteOffset);
            }
            case UINTEGER16: {
                return DecodeUtils.uInteger16Type(datagram, byteOffset, policy);
            }
            case INTEGER: {
                return DecodeUtils.integerType(datagram, byteOffset, policy);
            }
        }
        throw new DecodeException(DecodeException.DecodeError.ILLEGAL_PROTOCOL_VERSION_TYPE);
    }

    public static void encode(byte[] datagram, Class<?> protocolClass) {
        if (!protocolClass.isAnnotationPresent(ProtocolVersion.class)) {
            return;
        }
        ProtocolVersion versionAnnotation = protocolClass.getAnnotation(ProtocolVersion.class);
        EndianPolicy policy = Optional.ofNullable(protocolClass.getAnnotation(Endian.class)).map(Endian::value).orElse(EndianPolicy.LITTLE);
        int byteOffset = versionAnnotation.value();
        int version = versionAnnotation.version();
        switch (versionAnnotation.protocolType()) {
            case UINTEGER8: {
                EncodeUtils.uInteger8Type(datagram, byteOffset, version);
                break;
            }
            case UINTEGER16: {
                EncodeUtils.uInteger16Type(datagram, byteOffset, policy, version);
                break;
            }
            case INTEGER: {
                EncodeUtils.integerType(datagram, byteOffset, policy, version);
                break;
            }
            default: {
                throw new EncodeException(EncodeException.EncodeError.ILLEGAL_PROTOCOL_VERSION_TYPE);
            }
        }
    }
}

