/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.decoder;

import lombok.NonNull;
import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.annotation.type.UInteger32Type;
import org.indunet.fastproto.decoder.DecodeContext;
import org.indunet.fastproto.decoder.TypeDecoder;
import org.indunet.fastproto.exception.DecodeException;

public class UInteger32Decoder
implements TypeDecoder<Long> {
    @Override
    public Long decode(@NonNull DecodeContext context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        UInteger32Type type = context.getTypeAnnotation(UInteger32Type.class);
        EndianPolicy policy = context.getEndianPolicy();
        return this.decode(context.getDatagram(), type.value(), policy);
    }

    public long decode(@NonNull byte[] datagram, int byteOffset, @NonNull EndianPolicy policy) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (policy == null) {
            throw new NullPointerException("policy is marked non-null but is null");
        }
        int n = byteOffset = byteOffset >= 0 ? byteOffset : datagram.length + byteOffset;
        if (byteOffset < 0) {
            throw new DecodeException(DecodeException.DecodeError.ILLEGAL_BYTE_OFFSET);
        }
        if (byteOffset + 4 > datagram.length) {
            throw new DecodeException(DecodeException.DecodeError.EXCEEDED_DATAGRAM_SIZE);
        }
        long value = 0L;
        if (policy == EndianPolicy.LITTLE) {
            value |= (long)(datagram[byteOffset] & 0xFF);
            value |= ((long)datagram[byteOffset + 1] & 0xFFL) << 8;
            value |= ((long)datagram[byteOffset + 2] & 0xFFL) << 16;
            value |= ((long)datagram[byteOffset + 3] & 0xFFL) << 24;
        } else if (policy == EndianPolicy.BIG) {
            value |= (long)(datagram[byteOffset + 3] & 0xFF);
            value |= ((long)datagram[byteOffset + 2] & 0xFFL) << 8;
            value |= ((long)datagram[byteOffset + 1] & 0xFFL) << 16;
            value |= ((long)datagram[byteOffset] & 0xFFL) << 24;
        }
        return value;
    }
}

