/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.decoder;

import java.math.BigInteger;
import lombok.NonNull;
import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.annotation.type.UInteger64Type;
import org.indunet.fastproto.decoder.DecodeContext;
import org.indunet.fastproto.decoder.TypeDecoder;
import org.indunet.fastproto.exception.DecodeException;

public class UInteger64Decoder
implements TypeDecoder<BigInteger> {
    @Override
    public BigInteger decode(DecodeContext context) {
        UInteger64Type type = context.getTypeAnnotation(UInteger64Type.class);
        return this.decode(context.getDatagram(), type.value(), context.getEndianPolicy());
    }

    public BigInteger decode(@NonNull byte[] datagram, int byteOffset, @NonNull EndianPolicy endian) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (endian == null) {
            throw new NullPointerException("endian is marked non-null but is null");
        }
        int n = byteOffset = byteOffset >= 0 ? byteOffset : datagram.length + byteOffset;
        if (byteOffset < 0) {
            throw new DecodeException(DecodeException.DecodeError.ILLEGAL_BYTE_OFFSET);
        }
        if (byteOffset + 8 > datagram.length) {
            throw new DecodeException(DecodeException.DecodeError.EXCEEDED_DATAGRAM_SIZE);
        }
        long low = 0L;
        long high = 0L;
        if (endian == EndianPolicy.LITTLE) {
            low |= (long)(datagram[byteOffset] & 0xFF);
            low |= ((long)datagram[byteOffset + 1] & 0xFFL) << 8;
            low |= ((long)datagram[byteOffset + 2] & 0xFFL) << 16;
            low |= ((long)datagram[byteOffset + 3] & 0xFFL) << 24;
            high |= (long)datagram[byteOffset + 4] & 0xFFL;
            high |= ((long)datagram[byteOffset + 5] & 0xFFL) << 8;
            high |= ((long)datagram[byteOffset + 6] & 0xFFL) << 16;
            high |= ((long)datagram[byteOffset + 7] & 0xFFL) << 24;
        } else if (endian == EndianPolicy.BIG) {
            low |= (long)(datagram[byteOffset + 7] & 0xFF);
            low |= ((long)datagram[byteOffset + 6] & 0xFFL) << 8;
            low |= ((long)datagram[byteOffset + 5] & 0xFFL) << 16;
            low |= ((long)datagram[byteOffset + 4] & 0xFFL) << 24;
            high |= (long)datagram[byteOffset + 3] & 0xFFL;
            high |= ((long)datagram[byteOffset + 2] & 0xFFL) << 8;
            high |= ((long)datagram[byteOffset + 1] & 0xFFL) << 16;
            high |= ((long)datagram[byteOffset] & 0xFFL) << 24;
        }
        return new BigInteger(String.valueOf(high)).multiply(new BigInteger(String.valueOf(0x100000000L))).add(new BigInteger(String.valueOf(low)));
    }
}

