/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.decoder;

import lombok.NonNull;
import org.indunet.fastproto.annotation.type.UInteger8Type;
import org.indunet.fastproto.decoder.DecodeContext;
import org.indunet.fastproto.decoder.TypeDecoder;
import org.indunet.fastproto.exception.DecodeException;

public class UInteger8Decoder
implements TypeDecoder<Integer> {
    @Override
    public Integer decode(@NonNull DecodeContext context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        UInteger8Type type = context.getTypeAnnotation(UInteger8Type.class);
        return this.decode(context.getDatagram(), type.value());
    }

    public int decode(@NonNull byte[] datagram, int byteOffset) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        int n = byteOffset = byteOffset >= 0 ? byteOffset : datagram.length + byteOffset;
        if (byteOffset < 0) {
            throw new DecodeException(DecodeException.DecodeError.ILLEGAL_BYTE_OFFSET);
        }
        if (byteOffset + 1 > datagram.length) {
            throw new DecodeException(DecodeException.DecodeError.EXCEEDED_DATAGRAM_SIZE);
        }
        return datagram[byteOffset] & 0xFF;
    }
}

