/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.encoder;

import org.indunet.fastproto.annotation.type.BooleanType;
import org.indunet.fastproto.encoder.EncodeContext;
import org.indunet.fastproto.encoder.TypeEncoder;
import org.indunet.fastproto.exception.EncodeException;

public class BooleanEncoder
implements TypeEncoder {
    @Override
    public void encode(EncodeContext context) {
        BooleanType type = context.getTypeAnnotation(BooleanType.class);
        Boolean value = context.getValue(Boolean.class);
        this.encode(context.getDatagram(), type.value(), type.bitOffset(), value);
    }

    public void encode(byte[] datagram, int byteOffset, int bitOffset, boolean value) {
        int n = byteOffset = byteOffset >= 0 ? byteOffset : datagram.length + byteOffset;
        if (byteOffset < 0) {
            throw new EncodeException(EncodeException.EncodeError.ILLEGAL_BYTE_OFFSET);
        }
        if (byteOffset >= datagram.length) {
            throw new EncodeException(EncodeException.EncodeError.EXCEEDED_DATAGRAM_SIZE);
        }
        if (bitOffset < 0 || bitOffset > 7) {
            throw new EncodeException(EncodeException.EncodeError.ILLEGAL_BIT_OFFSET);
        }
        if (value) {
            int n2 = byteOffset;
            datagram[n2] = (byte)(datagram[n2] | 1 << bitOffset);
        } else {
            int n3 = byteOffset;
            datagram[n3] = (byte)(datagram[n3] & ~(1 << bitOffset));
        }
    }
}

