/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.encoder;

import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.annotation.type.FloatType;
import org.indunet.fastproto.encoder.EncodeContext;
import org.indunet.fastproto.encoder.TypeEncoder;
import org.indunet.fastproto.exception.EncodeException;

public class FloatEncoder
implements TypeEncoder {
    @Override
    public void encode(EncodeContext context) {
        FloatType type = context.getTypeAnnotation(FloatType.class);
        Float value = context.getValue(Float.class);
        this.encode(context.getDatagram(), type.value(), context.getEndianPolicy(), value.floatValue());
    }

    public void encode(byte[] datagram, int byteOffset, EndianPolicy endian, float value) {
        int n = byteOffset = byteOffset >= 0 ? byteOffset : datagram.length + byteOffset;
        if (byteOffset < 0) {
            throw new EncodeException(EncodeException.EncodeError.ILLEGAL_BYTE_OFFSET);
        }
        if (byteOffset + 4 > datagram.length) {
            throw new EncodeException(EncodeException.EncodeError.EXCEEDED_DATAGRAM_SIZE);
        }
        int bits = Float.floatToIntBits(value);
        if (endian == EndianPolicy.LITTLE) {
            datagram[byteOffset] = (byte)((long)bits & 0xFFL);
            datagram[byteOffset + 1] = (byte)((long)(bits >> 8) & 0xFFL);
            datagram[byteOffset + 2] = (byte)((long)(bits >> 16) & 0xFFL);
            datagram[byteOffset + 3] = (byte)((long)(bits >> 24) & 0xFFL);
        } else if (endian == EndianPolicy.BIG) {
            datagram[byteOffset + 3] = (byte)((long)bits & 0xFFL);
            datagram[byteOffset + 2] = (byte)((long)(bits >> 8) & 0xFFL);
            datagram[byteOffset + 1] = (byte)((long)(bits >> 16) & 0xFFL);
            datagram[byteOffset] = (byte)((long)(bits >> 24) & 0xFFL);
        }
    }
}

