/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.encoder;

import java.math.BigInteger;
import java.text.MessageFormat;
import lombok.NonNull;
import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.annotation.type.UInteger64Type;
import org.indunet.fastproto.encoder.EncodeContext;
import org.indunet.fastproto.encoder.TypeEncoder;
import org.indunet.fastproto.exception.EncodeException;

public class UInteger64Encoder
implements TypeEncoder {
    @Override
    public void encode(EncodeContext context) {
        UInteger64Type type = context.getTypeAnnotation(UInteger64Type.class);
        BigInteger value = context.getValue(BigInteger.class);
        this.encode(context.getDatagram(), type.value(), context.getEndianPolicy(), value);
    }

    public void encode(@NonNull byte[] datagram, int byteOffset, @NonNull EndianPolicy policy, BigInteger value) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (policy == null) {
            throw new NullPointerException("policy is marked non-null but is null");
        }
        int n = byteOffset = byteOffset >= 0 ? byteOffset : datagram.length + byteOffset;
        if (byteOffset < 0) {
            throw new EncodeException(EncodeException.EncodeError.ILLEGAL_BYTE_OFFSET);
        }
        if (byteOffset + 8 > datagram.length) {
            throw new EncodeException(EncodeException.EncodeError.EXCEEDED_DATAGRAM_SIZE);
        }
        if (value.compareTo(UInteger64Type.MAX_VALUE) > 0 || value.compareTo(UInteger64Type.MIN_VALUE) < 0) {
            throw new EncodeException(MessageFormat.format(EncodeException.EncodeError.EXCEEDED_TYPE_SIZE_LIMIT.getMessage(), UInteger64Type.class.getName()));
        }
        long low = value.and(new BigInteger(String.valueOf(0xFFFFFFFFL))).longValueExact();
        long high = value.shiftRight(32).longValueExact();
        if (policy == EndianPolicy.BIG) {
            datagram[byteOffset + 7] = (byte)(low & 0xFFL);
            datagram[byteOffset + 6] = (byte)(low >> 8 & 0xFFL);
            datagram[byteOffset + 5] = (byte)(low >> 16 & 0xFFL);
            datagram[byteOffset + 4] = (byte)(low >> 24 & 0xFFL);
            datagram[byteOffset + 3] = (byte)(high & 0xFFL);
            datagram[byteOffset + 2] = (byte)(high >> 8 & 0xFFL);
            datagram[byteOffset + 1] = (byte)(high >> 16 & 0xFFL);
            datagram[byteOffset] = (byte)(high >> 24 & 0xFFL);
        } else {
            datagram[byteOffset] = (byte)(low & 0xFFL);
            datagram[byteOffset + 1] = (byte)(low >> 8 & 0xFFL);
            datagram[byteOffset + 2] = (byte)(low >> 16 & 0xFFL);
            datagram[byteOffset + 3] = (byte)(low >> 24 & 0xFFL);
            datagram[byteOffset + 4] = (byte)(high & 0xFFL);
            datagram[byteOffset + 5] = (byte)(high >> 8 & 0xFFL);
            datagram[byteOffset + 6] = (byte)(high >> 16 & 0xFFL);
            datagram[byteOffset + 7] = (byte)(high >> 24 & 0xFFL);
        }
    }
}

