/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.encoder;

import java.text.MessageFormat;
import lombok.NonNull;
import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.annotation.type.UInteger8Type;
import org.indunet.fastproto.encoder.EncodeContext;
import org.indunet.fastproto.encoder.TypeEncoder;
import org.indunet.fastproto.exception.EncodeException;

public class UInteger8Encoder
implements TypeEncoder {
    @Override
    public void encode(@NonNull EncodeContext context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        UInteger8Type type = context.getTypeAnnotation(UInteger8Type.class);
        EndianPolicy policy = context.getEndianPolicy();
        Integer value = context.getValue(Integer.class);
        this.encode(context.getDatagram(), type.value(), value);
    }

    public void encode(@NonNull byte[] datagram, int byteOffset, int value) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        int n = byteOffset = byteOffset >= 0 ? byteOffset : datagram.length + byteOffset;
        if (byteOffset < 0) {
            throw new EncodeException(EncodeException.EncodeError.ILLEGAL_BYTE_OFFSET);
        }
        if (byteOffset + 1 > datagram.length) {
            throw new EncodeException(EncodeException.EncodeError.EXCEEDED_DATAGRAM_SIZE);
        }
        if (value > 255 || value < 0) {
            throw new EncodeException(MessageFormat.format(EncodeException.EncodeError.EXCEEDED_TYPE_SIZE_LIMIT.getMessage(), UInteger8Type.class.getName()));
        }
        datagram[byteOffset] = (byte)value;
    }
}

