/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.NonNull;
import org.indunet.fastproto.TypeAssist;
import org.indunet.fastproto.VersionAssist;
import org.indunet.fastproto.annotation.CheckSum;
import org.indunet.fastproto.annotation.EnableCompress;
import org.indunet.fastproto.check.Checker;
import org.indunet.fastproto.check.CheckerFactory;
import org.indunet.fastproto.check.CheckerUtils;
import org.indunet.fastproto.compress.Compressor;
import org.indunet.fastproto.compress.CompressorFactory;
import org.indunet.fastproto.decoder.DecodeContext;
import org.indunet.fastproto.decoder.DecoderFactory;
import org.indunet.fastproto.encoder.EncodeContext;
import org.indunet.fastproto.encoder.EncoderFactory;
import org.indunet.fastproto.exception.DecodeException;

public class FastProto {
    protected static ConcurrentHashMap<Class<?>, TypeAssist> assists = new ConcurrentHashMap();

    public static <T> T parseFrom(@NonNull byte[] datagram, @NonNull Class<T> clazz) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return FastProto.parseFrom(datagram, clazz, true);
    }

    public static <T> T parseFrom(@NonNull byte[] datagram, @NonNull Class<T> protocolClass, boolean enableCompress) {
        Checker checker;
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (protocolClass == null) {
            throw new NullPointerException("protocolClass is marked non-null but is null");
        }
        if (enableCompress && protocolClass.isAnnotationPresent(EnableCompress.class)) {
            EnableCompress compress = protocolClass.getAnnotation(EnableCompress.class);
            Compressor compressor = CompressorFactory.create(compress);
            datagram = compressor.decompress(datagram);
        }
        if (protocolClass.isAnnotationPresent(CheckSum.class) && !(checker = CheckerFactory.create(protocolClass.getAnnotation(CheckSum.class))).validate(datagram, protocolClass)) {
            throw new DecodeException(DecodeException.DecodeError.ILLEGAL_CHECK_SUM);
        }
        if (!VersionAssist.validate(datagram, protocolClass)) {
            throw new DecodeException(DecodeException.DecodeError.PROTOCOL_VERSION_NOT_MATCH);
        }
        TypeAssist assist = assists.computeIfAbsent(protocolClass, c -> TypeAssist.of(c));
        List<DecodeContext> contexts = assist.toDecodeContexts(datagram);
        contexts.parallelStream().forEach(c -> {
            TypeAssist a = c.getTypeAssist();
            Function<DecodeContext, ?> func = DecoderFactory.getDecoder(a.getDecoderClass(), a.getDecodeFormula());
            Object value = func.apply((DecodeContext)c);
            Object o = c.getObject();
            a.setValue(o, value);
        });
        return assist.getObject(protocolClass);
    }

    public static byte[] toByteArray(@NonNull Object object) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        return FastProto.toByteArray(object, true);
    }

    public static byte[] toByteArray(@NonNull Object object, boolean enableCompress) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        TypeAssist assist = assists.computeIfAbsent(object.getClass(), c -> TypeAssist.of(c));
        int length = assist.getMaxLength();
        length += CheckerUtils.getSize(object.getClass());
        return FastProto.toByteArray(object, length += VersionAssist.getSize(object.getClass()), enableCompress);
    }

    public static byte[] toByteArray(@NonNull Object object, int length) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        return FastProto.toByteArray(object, length, true);
    }

    public static byte[] toByteArray(@NonNull Object object, int length, boolean enableCompress) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        byte[] datagram = new byte[length];
        TypeAssist assist = assists.computeIfAbsent(object.getClass(), c -> TypeAssist.of(c));
        List<EncodeContext> contexts = assist.toEncodeContexts(object, datagram);
        contexts.stream().forEach(c -> {
            if (c.getTypeAssist().getEncodeFormula() != null) {
                Object o = EncoderFactory.getFormula(c.getTypeAssist().getEncodeFormula()).apply(c.getValue());
                c.setValue(o);
            }
            Consumer<EncodeContext> consumer = EncoderFactory.getEncoder(c.getTypeAssist().getEncoderClass());
            consumer.accept((EncodeContext)c);
        });
        VersionAssist.encode(datagram, object.getClass());
        if (object.getClass().isAnnotationPresent(CheckSum.class)) {
            CheckSum checkSum = object.getClass().getAnnotation(CheckSum.class);
            Checker checker = CheckerFactory.create(checkSum);
            checker.setValue(datagram, object.getClass());
        }
        if (enableCompress && object.getClass().isAnnotationPresent(EnableCompress.class)) {
            EnableCompress annotation = object.getClass().getAnnotation(EnableCompress.class);
            Compressor compressor = CompressorFactory.create(annotation);
            return compressor.compress(datagram);
        }
        return datagram;
    }
}

