/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.check;

import java.util.zip.CRC32;
import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.annotation.CheckSum;
import org.indunet.fastproto.annotation.Endian;
import org.indunet.fastproto.check.Checker;
import org.indunet.fastproto.decoder.DecodeUtils;
import org.indunet.fastproto.encoder.EncodeUtils;
import org.indunet.fastproto.exception.DecodeException;

public class Crc32Checker
implements Checker {
    protected static final Crc32Checker checker = new Crc32Checker();

    public static Crc32Checker getInstance() {
        return checker;
    }

    @Override
    public boolean validate(byte[] datagram, Class<?> protocolClass) {
        if (!protocolClass.isAnnotationPresent(CheckSum.class)) {
            return true;
        }
        CheckSum checkSum = protocolClass.getAnnotation(CheckSum.class);
        int byteOffset = checkSum.byteOffset();
        int length = checkSum.length();
        EndianPolicy policy = checkSum.endianPolicy().length != 0 ? checkSum.endianPolicy()[0] : (protocolClass.isAnnotationPresent(Endian.class) ? protocolClass.getAnnotation(Endian.class).value() : EndianPolicy.LITTLE);
        long actual = this.getValue(datagram, byteOffset, length);
        int bo = byteOffset >= 0 ? byteOffset : datagram.length + byteOffset;
        int l = length >= 0 ? length : datagram.length + length - bo;
        long expected = DecodeUtils.uInteger32Type(datagram, bo + l, policy);
        return actual == expected;
    }

    public long getValue(byte[] datagram, int byteOffset, int length) {
        int l;
        int bo = byteOffset >= 0 ? byteOffset : datagram.length + byteOffset;
        int n = l = length >= 0 ? length : datagram.length + length - bo;
        if (bo < 0) {
            throw new DecodeException(DecodeException.DecodeError.ILLEGAL_BYTE_OFFSET);
        }
        if (l < 0) {
            throw new DecodeException(DecodeException.DecodeError.ILLEGAL_PARAMETER);
        }
        if (bo + length > datagram.length) {
            throw new DecodeException(DecodeException.DecodeError.EXCEEDED_DATAGRAM_SIZE);
        }
        CRC32 crc32 = new CRC32();
        crc32.update(datagram, bo, l);
        return crc32.getValue();
    }

    @Override
    public void setValue(byte[] datagram, Class<?> protocolClass) {
        if (!protocolClass.isAnnotationPresent(CheckSum.class)) {
            return;
        }
        CheckSum checkSum = protocolClass.getAnnotation(CheckSum.class);
        int byteOffset = checkSum.byteOffset();
        int length = checkSum.length();
        EndianPolicy policy = checkSum.endianPolicy().length != 0 ? checkSum.endianPolicy()[0] : (protocolClass.isAnnotationPresent(Endian.class) ? protocolClass.getAnnotation(Endian.class).value() : EndianPolicy.LITTLE);
        this.setValue(datagram, byteOffset, length, policy);
    }

    @Override
    public int getSize() {
        return 4;
    }

    public void setValue(byte[] datagram, int byteOffset, int length, EndianPolicy policy) {
        int bo = byteOffset >= 0 ? byteOffset : datagram.length + byteOffset;
        int l = length >= 0 ? length : datagram.length + length - bo;
        long value = this.getValue(datagram, byteOffset, length);
        EncodeUtils.uInteger32Type(datagram, bo + l, policy, value);
    }
}

