/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.decoder;

import lombok.NonNull;
import org.indunet.fastproto.annotation.type.BinaryType;
import org.indunet.fastproto.decoder.DecodeContext;
import org.indunet.fastproto.decoder.TypeDecoder;
import org.indunet.fastproto.exception.DecodeException;

public class BinaryDecoder
implements TypeDecoder<byte[]> {
    @Override
    public byte[] decode(@NonNull DecodeContext context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        BinaryType type = context.getTypeAnnotation(BinaryType.class);
        return this.decode(context.getDatagram(), type.value(), type.length());
    }

    public byte[] decode(@NonNull byte[] datagram, int byteOffset, int length) {
        int l;
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        int bo = byteOffset >= 0 ? byteOffset : datagram.length + byteOffset;
        int n = l = length >= 0 ? length : datagram.length + length - bo + 1;
        if (bo < 0) {
            throw new DecodeException(DecodeException.DecodeError.ILLEGAL_BYTE_OFFSET);
        }
        if (bo >= datagram.length) {
            throw new DecodeException(DecodeException.DecodeError.ILLEGAL_BYTE_OFFSET);
        }
        if (l <= 0) {
            throw new DecodeException(DecodeException.DecodeError.ILLEGAL_PARAMETER);
        }
        if (bo + l > datagram.length) {
            throw new DecodeException(DecodeException.DecodeError.EXCEEDED_DATAGRAM_SIZE);
        }
        byte[] bytes = new byte[l];
        System.arraycopy(datagram, bo, bytes, 0, l);
        return bytes;
    }
}

