/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.decoder;

import lombok.NonNull;
import org.indunet.fastproto.annotation.type.BooleanType;
import org.indunet.fastproto.decoder.DecodeContext;
import org.indunet.fastproto.decoder.TypeDecoder;
import org.indunet.fastproto.exception.DecodeException;

public class BooleanDecoder
implements TypeDecoder<Boolean> {
    @Override
    public Boolean decode(DecodeContext context) {
        BooleanType type = context.getTypeAnnotation(BooleanType.class);
        return this.decode(context.getDatagram(), type.value(), type.bitOffset());
    }

    public boolean decode(@NonNull byte[] datagram, int byteOffset, int bitOffset) {
        int bo;
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        int n = bo = byteOffset >= 0 ? byteOffset : datagram.length + byteOffset;
        if (bo < 0) {
            throw new DecodeException(DecodeException.DecodeError.ILLEGAL_BYTE_OFFSET);
        }
        if (bitOffset > 7 || bitOffset < 0) {
            throw new DecodeException(DecodeException.DecodeError.ILLEGAL_BIT_OFFSET);
        }
        if (bo >= datagram.length) {
            throw new DecodeException(DecodeException.DecodeError.EXCEEDED_DATAGRAM_SIZE);
        }
        return (datagram[bo] & 1 << bitOffset) != 0;
    }
}

