/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.decoder;

import lombok.NonNull;
import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.annotation.type.CharacterType;
import org.indunet.fastproto.decoder.DecodeContext;
import org.indunet.fastproto.decoder.TypeDecoder;
import org.indunet.fastproto.exception.DecodeException;

public class CharacterDecoder
implements TypeDecoder<Character> {
    @Override
    public Character decode(DecodeContext context) {
        CharacterType type = context.getTypeAnnotation(CharacterType.class);
        EndianPolicy policy = context.getEndianPolicy();
        return this.decode(context.getDatagram(), type.value(), policy);
    }

    public Character decode(byte[] datagram, int byteOffset, @NonNull EndianPolicy policy) {
        int bo;
        if (policy == null) {
            throw new NullPointerException("policy is marked non-null but is null");
        }
        int n = bo = byteOffset >= 0 ? byteOffset : datagram.length + byteOffset;
        if (bo < 0) {
            throw new DecodeException(DecodeException.DecodeError.ILLEGAL_BYTE_OFFSET);
        }
        if (bo + 2 > datagram.length) {
            throw new DecodeException(DecodeException.DecodeError.EXCEEDED_DATAGRAM_SIZE);
        }
        int value = 0;
        value = policy == EndianPolicy.BIG ? (datagram[bo] & 0xFF) * 256 + (datagram[bo + 1] & 0xFF) : (datagram[bo + 1] & 0xFF) * 256 + (datagram[bo] & 0xFF);
        return Character.valueOf((char)value);
    }
}

