/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.decoder;

import lombok.NonNull;
import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.annotation.type.DoubleType;
import org.indunet.fastproto.decoder.DecodeContext;
import org.indunet.fastproto.decoder.TypeDecoder;
import org.indunet.fastproto.exception.DecodeException;

public class DoubleDecoder
implements TypeDecoder<Double> {
    @Override
    public Double decode(DecodeContext context) {
        DoubleType type = context.getTypeAnnotation(DoubleType.class);
        return this.decode(context.getDatagram(), type.value(), context.getEndianPolicy());
    }

    public double decode(@NonNull byte[] datagram, int byteOffset, @NonNull EndianPolicy endian) {
        int bo;
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (endian == null) {
            throw new NullPointerException("endian is marked non-null but is null");
        }
        int n = bo = byteOffset >= 0 ? byteOffset : datagram.length + byteOffset;
        if (bo < 0) {
            throw new DecodeException(DecodeException.DecodeError.ILLEGAL_BYTE_OFFSET);
        }
        if (bo + 8 > datagram.length) {
            throw new DecodeException(DecodeException.DecodeError.EXCEEDED_DATAGRAM_SIZE);
        }
        long value = 0L;
        if (endian == EndianPolicy.LITTLE) {
            value |= (long)datagram[bo] & 0xFFL;
            value |= ((long)datagram[bo + 1] & 0xFFL) << 8;
            value |= ((long)datagram[bo + 2] & 0xFFL) << 16;
            value |= ((long)datagram[bo + 3] & 0xFFL) << 24;
            value |= ((long)datagram[bo + 4] & 0xFFL) << 32;
            value |= ((long)datagram[bo + 5] & 0xFFL) << 40;
            value |= ((long)datagram[bo + 6] & 0xFFL) << 48;
            value |= ((long)datagram[bo + 7] & 0xFFL) << 56;
        } else if (endian == EndianPolicy.BIG) {
            value |= (long)datagram[bo + 7] & 0xFFL;
            value |= ((long)datagram[bo + 6] & 0xFFL) << 8;
            value |= ((long)datagram[bo + 5] & 0xFFL) << 16;
            value |= ((long)datagram[bo + 4] & 0xFFL) << 24;
            value |= ((long)datagram[bo + 3] & 0xFFL) << 32;
            value |= ((long)datagram[bo + 2] & 0xFFL) << 40;
            value |= ((long)datagram[bo + 1] & 0xFFL) << 48;
            value |= ((long)datagram[bo] & 0xFFL) << 56;
        }
        return Double.longBitsToDouble(value);
    }
}

