/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.decoder;

import lombok.NonNull;
import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.annotation.type.ShortType;
import org.indunet.fastproto.decoder.DecodeContext;
import org.indunet.fastproto.decoder.TypeDecoder;
import org.indunet.fastproto.exception.DecodeException;

public class ShortDecoder
implements TypeDecoder<Short> {
    @Override
    public Short decode(@NonNull DecodeContext context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        ShortType type = context.getTypeAnnotation(ShortType.class);
        return this.decode(context.getDatagram(), type.value(), context.getEndianPolicy());
    }

    public short decode(@NonNull byte[] datagram, int byteOffset, @NonNull EndianPolicy endian) {
        int bo;
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (endian == null) {
            throw new NullPointerException("endian is marked non-null but is null");
        }
        int n = bo = byteOffset >= 0 ? byteOffset : datagram.length + byteOffset;
        if (bo < 0) {
            throw new DecodeException(DecodeException.DecodeError.ILLEGAL_BYTE_OFFSET);
        }
        if (bo + 2 > datagram.length) {
            throw new DecodeException(DecodeException.DecodeError.EXCEEDED_DATAGRAM_SIZE);
        }
        short value = 0;
        if (endian == EndianPolicy.LITTLE) {
            value = (short)(value | datagram[bo] & 0xFF);
            value = (short)(value | datagram[bo + 1] << 8);
        } else if (endian == EndianPolicy.BIG) {
            value = (short)(value | datagram[bo + 1] & 0xFF);
            value = (short)(value | datagram[bo] << 8);
        }
        return value;
    }
}

