/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.encoder;

import lombok.NonNull;
import org.indunet.fastproto.annotation.type.BinaryType;
import org.indunet.fastproto.encoder.EncodeContext;
import org.indunet.fastproto.encoder.TypeEncoder;
import org.indunet.fastproto.exception.EncodeException;

public class BinaryEncoder
implements TypeEncoder {
    @Override
    public void encode(@NonNull EncodeContext context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        BinaryType type = context.getTypeAnnotation(BinaryType.class);
        byte[] bytes = context.getValue(byte[].class);
        this.encode(context.getDatagram(), type.value(), type.length(), bytes);
    }

    public void encode(@NonNull byte[] datagram, int byteOffset, int length, @NonNull byte[] bytes) {
        int l;
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        int bo = byteOffset >= 0 ? byteOffset : datagram.length + byteOffset;
        int n = l = length >= 0 ? length : datagram.length + length - bo + 1;
        if (bo < 0) {
            throw new EncodeException(EncodeException.EncodeError.ILLEGAL_BYTE_OFFSET);
        }
        if (bo >= datagram.length) {
            throw new EncodeException(EncodeException.EncodeError.ILLEGAL_BYTE_OFFSET);
        }
        if (l <= 0) {
            throw new EncodeException(EncodeException.EncodeError.ILLEGAL_BYTE_OFFSET);
        }
        if (bo + l > datagram.length) {
            throw new EncodeException(EncodeException.EncodeError.EXCEEDED_DATAGRAM_SIZE);
        }
        if (l >= bytes.length) {
            System.arraycopy(bytes, 0, datagram, bo, bytes.length);
        } else {
            System.arraycopy(bytes, 0, datagram, bo, l);
        }
    }
}

