/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.encoder;

import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.annotation.type.CharacterType;
import org.indunet.fastproto.encoder.EncodeContext;
import org.indunet.fastproto.encoder.TypeEncoder;
import org.indunet.fastproto.exception.EncodeException;

public class CharacterEncoder
implements TypeEncoder {
    @Override
    public void encode(EncodeContext context) {
        CharacterType type = context.getTypeAnnotation(CharacterType.class);
        Character value = context.getValue(Character.class);
        EndianPolicy policy = context.getEndianPolicy();
        this.encode(context.getDatagram(), type.value(), policy, value.charValue());
    }

    public void encode(byte[] datagram, int byteOffset, EndianPolicy policy, char value) {
        int bo;
        int n = bo = byteOffset >= 0 ? byteOffset : datagram.length + byteOffset;
        if (bo < 0) {
            throw new EncodeException(EncodeException.EncodeError.ILLEGAL_BYTE_OFFSET);
        }
        if (bo + 2 > datagram.length) {
            throw new EncodeException(EncodeException.EncodeError.EXCEEDED_DATAGRAM_SIZE);
        }
        if (policy == EndianPolicy.BIG) {
            int n2 = bo;
            datagram[n2] = (byte)(datagram[n2] | value >> 8 & 0xFF);
            int n3 = bo + 1;
            datagram[n3] = (byte)(datagram[n3] | value & 0xFF);
        } else {
            int n4 = bo + 1;
            datagram[n4] = (byte)(datagram[n4] | value >> 8 & 0xFF);
            int n5 = bo;
            datagram[n5] = (byte)(datagram[n5] | value & 0xFF);
        }
    }
}

