/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.encoder;

import lombok.NonNull;
import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.annotation.type.LongType;
import org.indunet.fastproto.encoder.EncodeContext;
import org.indunet.fastproto.encoder.TypeEncoder;
import org.indunet.fastproto.exception.EncodeException;

public class LongEncoder
implements TypeEncoder {
    @Override
    public void encode(@NonNull EncodeContext context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        LongType type = context.getTypeAnnotation(LongType.class);
        Long value = context.getValue(Long.class);
        this.encode(context.getDatagram(), type.value(), context.getEndianPolicy(), value);
    }

    public void encode(@NonNull byte[] datagram, int byteOffset, @NonNull EndianPolicy policy, long value) {
        int bo;
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (policy == null) {
            throw new NullPointerException("policy is marked non-null but is null");
        }
        int n = bo = byteOffset >= 0 ? byteOffset : datagram.length + byteOffset;
        if (bo < 0) {
            throw new EncodeException(EncodeException.EncodeError.ILLEGAL_BYTE_OFFSET);
        }
        if (bo + 8 > datagram.length) {
            throw new EncodeException(EncodeException.EncodeError.EXCEEDED_DATAGRAM_SIZE);
        }
        if (policy == EndianPolicy.BIG) {
            datagram[bo + 7] = (byte)(value & 0xFFL);
            datagram[bo + 6] = (byte)(value >> 8 & 0xFFL);
            datagram[bo + 5] = (byte)(value >> 16 & 0xFFL);
            datagram[bo + 4] = (byte)(value >> 24 & 0xFFL);
            datagram[bo + 3] = (byte)(value >> 32 & 0xFFL);
            datagram[bo + 2] = (byte)(value >> 40 & 0xFFL);
            datagram[bo + 1] = (byte)(value >> 48 & 0xFFL);
            datagram[bo] = (byte)(value >> 56 & 0xFFL);
        } else {
            datagram[bo] = (byte)(value & 0xFFL);
            datagram[bo + 1] = (byte)(value >> 8 & 0xFFL);
            datagram[bo + 2] = (byte)(value >> 16 & 0xFFL);
            datagram[bo + 3] = (byte)(value >> 24 & 0xFFL);
            datagram[bo + 4] = (byte)(value >> 32 & 0xFFL);
            datagram[bo + 5] = (byte)(value >> 40 & 0xFFL);
            datagram[bo + 6] = (byte)(value >> 48 & 0xFFL);
            datagram[bo + 7] = (byte)(value >> 56 & 0xFFL);
        }
    }
}

