/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto;

import lombok.NonNull;
import org.indunet.fastproto.CodecFeature;
import org.indunet.fastproto.TypeAssist;
import org.indunet.fastproto.pipeline.CodecContext;
import org.indunet.fastproto.pipeline.FlowFactory;

public class FastProto {
    public static <T> T parseFrom(@NonNull byte[] datagram, @NonNull Class<T> protocolClass) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (protocolClass == null) {
            throw new NullPointerException("protocolClass is marked non-null but is null");
        }
        return FastProto.parseFrom(datagram, protocolClass, 0L);
    }

    public static <T> T parseFrom(@NonNull byte[] datagram, @NonNull Class<T> protocolClass, long ... codecFeatures) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (protocolClass == null) {
            throw new NullPointerException("protocolClass is marked non-null but is null");
        }
        TypeAssist assist = TypeAssist.byClass(protocolClass);
        long codecFeature = CodecFeature.of(codecFeatures);
        CodecContext context = CodecContext.builder().datagram(datagram).protocolClass(protocolClass).codecFeature(codecFeature).typeAssist(assist).build();
        FlowFactory.createDecode(assist.getCodecFeature() | codecFeature).process(context);
        return (T)context.getObject();
    }

    public static byte[] toByteArray(@NonNull Object object) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        return FastProto.toByteArray(object, 0L);
    }

    public static byte[] toByteArray(@NonNull Object object, int length) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        return FastProto.toByteArray(object, length, 0L);
    }

    public static byte[] toByteArray(@NonNull Object object, long ... codecFeatures) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        TypeAssist assist = TypeAssist.byClass(object.getClass());
        long codecFeature = CodecFeature.of(codecFeatures);
        CodecContext context = CodecContext.builder().object(object).protocolClass(object.getClass()).codecFeature(codecFeature).typeAssist(assist).build();
        FlowFactory.createEncode(assist.getCodecFeature() | codecFeature).process(context);
        return context.getDatagram();
    }

    public static byte[] toByteArray(@NonNull Object object, int length, long ... codecFeatures) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        TypeAssist assist = TypeAssist.byClass(object.getClass());
        long codecFeature = CodecFeature.of(codecFeatures);
        CodecContext context = CodecContext.builder().object(object).protocolClass(object.getClass()).codecFeature(codecFeature).datagram(new byte[length]).typeAssist(assist).build();
        FlowFactory.createEncode(assist.getCodecFeature() | 0x100L | codecFeature).process(context);
        return context.getDatagram();
    }
}

