/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.compress;

import java.io.ByteArrayOutputStream;
import java.text.MessageFormat;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import lombok.NonNull;
import org.indunet.fastproto.compress.Compressor;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.exception.CodecException;
import org.indunet.fastproto.exception.CompressException;

public class DeflateCompressor
implements Compressor {
    protected static final ConcurrentHashMap<Integer, DeflateCompressor> compressors = new ConcurrentHashMap();
    protected static final int MAX_LEVEL = 9;
    protected static final int MIN_LEVEL = 0;
    protected int level = 0;

    protected DeflateCompressor(int level) {
        this.level = level;
    }

    public static DeflateCompressor getInstance(int level) {
        if (level < 0 || level > 9) {
            throw new CodecException(CodecError.INVALID_COMPRESS_POLICY);
        }
        return compressors.computeIfAbsent(level, __ -> new DeflateCompressor(level));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized byte[] compress(@NonNull byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        Deflater deflater = new Deflater(this.level);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            deflater.setInput(bytes);
            deflater.finish();
            byte[] buffer = new byte[256];
            while (!deflater.finished()) {
                int n = deflater.deflate(buffer);
                out.write(buffer, 0, n);
            }
        }
        finally {
            deflater.end();
            out.close();
        }
        return out.toByteArray();
    }

    @Override
    public synchronized byte[] decompress(@NonNull byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        Inflater inflater = new Inflater();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            inflater.setInput(bytes);
            inflater.finished();
            byte[] buffer = new byte[256];
            while (!inflater.finished()) {
                int n = inflater.inflate(buffer);
                out.write(buffer, 0, n);
            }
        }
        catch (DataFormatException e) {
            throw new CompressException(MessageFormat.format(CodecError.FAIL_DECOMPRESS_DATAGRAM.getMessage(), this.getClass().getName()), (Throwable)e);
        }
        finally {
            inflater.end();
            out.close();
        }
        return out.toByteArray();
    }
}

