/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.crypto;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import lombok.NonNull;
import org.indunet.fastproto.crypto.Crypto;
import org.indunet.fastproto.crypto.CryptoPolicy;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.exception.CryptoException;

public class StandardCrypto
implements Crypto {
    protected static ConcurrentMap<String, StandardCrypto> ciphers = new ConcurrentHashMap<String, StandardCrypto>();
    protected String transformation;
    protected String algorithm;
    protected int keyLength;

    protected StandardCrypto(String transformation, int keyLength) {
        this.transformation = transformation;
        this.keyLength = keyLength;
        this.algorithm = transformation.split("/")[0];
    }

    public static StandardCrypto getInstance(@NonNull CryptoPolicy policy) {
        if (policy == null) {
            throw new NullPointerException("policy is marked non-null but is null");
        }
        return ciphers.computeIfAbsent(policy.transformation, __ -> new StandardCrypto(policy.transformation, policy.keyLength));
    }

    @Override
    public byte[] encrypt(byte[] key, byte[] datagram) {
        try {
            Cipher cipher = Cipher.getInstance(this.transformation);
            SecretKeySpec keySpec = new SecretKeySpec(this.generateKey(key, this.keyLength), this.algorithm);
            cipher.init(1, keySpec);
            return cipher.doFinal(datagram);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new CryptoException(CodecError.FAIL_ENCRYPTING, (Throwable)e);
        }
    }

    @Override
    public byte[] decrypt(byte[] key, byte[] datagram) {
        try {
            Cipher cipher = Cipher.getInstance(this.transformation);
            SecretKeySpec keySpec = new SecretKeySpec(this.generateKey(key, this.keyLength), this.algorithm);
            cipher.init(2, keySpec);
            return cipher.doFinal(datagram);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new CryptoException(CodecError.FAIL_DECRYPTING, (Throwable)e);
        }
    }

    public byte[] generateKey(@NonNull byte[] userKey, int length) {
        if (userKey == null) {
            throw new NullPointerException("userKey is marked non-null but is null");
        }
        if (userKey.length == 0) {
            throw new CryptoException(CodecError.INVALID_CRYPTO_KEY);
        }
        byte[] key = new byte[length];
        System.arraycopy(userKey, 0, key, 0, Math.min(userKey.length, length));
        return key;
    }
}

