/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.decoder;

import java.sql.Timestamp;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.ProtocolType;
import org.indunet.fastproto.annotation.type.TimestampType;
import org.indunet.fastproto.decoder.DecodeContext;
import org.indunet.fastproto.decoder.DecodeUtils;
import org.indunet.fastproto.decoder.TypeDecoder;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.exception.DecodeException;
import org.indunet.fastproto.exception.OutOfBoundsException;
import org.indunet.fastproto.util.ReverseUtils;

public class TimestampDecoder
implements TypeDecoder<Timestamp> {
    @Override
    public Timestamp decode(@NonNull DecodeContext context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        EndianPolicy policy = context.getEndianPolicy();
        TimestampType type = context.getTypeAnnotation(TimestampType.class);
        ProtocolType dataType = type.protocolType();
        return this.decode(context.getDatagram(), type.value(), dataType, policy, type.unit());
    }

    public Timestamp decode(@NonNull byte[] datagram, int byteOffset, @NonNull ProtocolType dataType, @NonNull EndianPolicy policy, @NonNull TimeUnit unit) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (dataType == null) {
            throw new NullPointerException("dataType is marked non-null but is null");
        }
        if (policy == null) {
            throw new NullPointerException("policy is marked non-null but is null");
        }
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        int bo = ReverseUtils.byteOffset(datagram.length, byteOffset);
        if (bo < 0) {
            throw new DecodeException(CodecError.ILLEGAL_BYTE_OFFSET);
        }
        if (dataType == ProtocolType.LONG && unit == TimeUnit.MILLISECONDS) {
            if (bo + 8 > datagram.length) {
                throw new OutOfBoundsException(CodecError.EXCEEDED_DATAGRAM_SIZE);
            }
            long value = DecodeUtils.longType(datagram, bo, policy);
            return new Timestamp(value);
        }
        if (dataType == ProtocolType.UINTEGER32 && unit == TimeUnit.SECONDS) {
            if (bo + 4 > datagram.length) {
                throw new OutOfBoundsException(CodecError.EXCEEDED_DATAGRAM_SIZE);
            }
            long value = DecodeUtils.uInteger32Type(datagram, bo, policy);
            return new Timestamp(value * 1000L);
        }
        throw new DecodeException(CodecError.ILLEGAL_TIMESTAMP_PARAMETERS);
    }
}

