/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.kafka;

import java.util.Map;
import org.apache.kafka.common.serialization.Deserializer;
import org.indunet.fastproto.FastProto;
import org.indunet.fastproto.kafka.ProtoKafkaException;

public class ProtoDeserializer
implements Deserializer<Object> {
    protected Class<?> protocolClass;

    public void configure(Map props, boolean isKey) {
        block5: {
            if (!props.containsKey("protocol.class")) {
                throw new ProtoKafkaException(ProtoKafkaException.ProtoKafkaError.DATAGRAM_LENGTH_NOT_FOUND);
            }
            Object protocolClass = props.get("protocol.class");
            if (protocolClass instanceof Class) {
                this.protocolClass = (Class)protocolClass;
                break block5;
            }
            if (protocolClass instanceof String) {
                this.protocolClass = Class.forName((String)protocolClass);
                break block5;
            }
            throw new ProtoKafkaException(ProtoKafkaException.ProtoKafkaError.INVALID_PROTOCOL_CLASS);
        }
    }

    public Object deserialize(String topic, byte[] bytes) {
        return FastProto.parseFrom(bytes, this.protocolClass);
    }
}

