/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.pipeline;

import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.exception.DecodeException;
import org.indunet.fastproto.pipeline.AbstractFlow;
import org.indunet.fastproto.pipeline.CodecContext;
import org.indunet.fastproto.pipeline.decode.DecodeFlow;
import org.indunet.fastproto.pipeline.decode.DecompressFlow;
import org.indunet.fastproto.pipeline.decode.DecryptFlow;
import org.indunet.fastproto.pipeline.decode.VerifyChecksumFlow;
import org.indunet.fastproto.pipeline.decode.VerifyProtocolVersionFlow;
import org.indunet.fastproto.pipeline.encode.CompressFlow;
import org.indunet.fastproto.pipeline.encode.EncodeFlow;
import org.indunet.fastproto.pipeline.encode.EncryptFlow;
import org.indunet.fastproto.pipeline.encode.InferLengthFlow;
import org.indunet.fastproto.pipeline.encode.WriteChecksumFlow;
import org.indunet.fastproto.pipeline.encode.WriteProtocolVersionFlow;

public class FlowFactory {
    protected static Class<? extends AbstractFlow>[] decodeFlowClasses = new Class[]{DecryptFlow.class, DecompressFlow.class, VerifyChecksumFlow.class, VerifyProtocolVersionFlow.class, DecodeFlow.class};
    protected static Class<? extends AbstractFlow>[] encodeFlowClasses = new Class[]{InferLengthFlow.class, EncodeFlow.class, WriteProtocolVersionFlow.class, WriteChecksumFlow.class, CompressFlow.class, EncryptFlow.class};
    protected static ConcurrentMap<Long, AbstractFlow> decodeFlows = new ConcurrentHashMap<Long, AbstractFlow>();
    protected static ConcurrentMap<Long, AbstractFlow> encodeFlows = new ConcurrentHashMap<Long, AbstractFlow>();

    public static AbstractFlow<CodecContext> createDecode(long codecFeature) {
        return decodeFlows.computeIfAbsent(codecFeature, __ -> FlowFactory.create(decodeFlowClasses, codecFeature));
    }

    public static AbstractFlow<CodecContext> createEncode(long codecFeature) {
        return encodeFlows.computeIfAbsent(codecFeature, __ -> FlowFactory.create(encodeFlowClasses, codecFeature));
    }

    protected static AbstractFlow create(Class<? extends AbstractFlow>[] flowClasses, long codecFeature) {
        AbstractFlow[] array = (AbstractFlow[])Arrays.stream(flowClasses).map(c -> {
            try {
                return (AbstractFlow)c.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new DecodeException(CodecError.FAIL_CREATING_DECODE_FLOW, (Throwable)e);
            }
        }).filter(f -> (f.getFlowCode() & codecFeature) == 0L).toArray(AbstractFlow[]::new);
        AbstractFlow flow = array[0];
        for (int i = 1; i < array.length; ++i) {
            flow.setNext(array[i]);
            flow = flow.next;
        }
        return array[0];
    }
}

