/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.pipeline.decode;

import org.indunet.fastproto.annotation.EnableChecksum;
import org.indunet.fastproto.checksum.Checker;
import org.indunet.fastproto.exception.CheckSumException;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.pipeline.AbstractFlow;
import org.indunet.fastproto.pipeline.CodecContext;

public class VerifyChecksumFlow
extends AbstractFlow<CodecContext> {
    public static final long FLOW_CODE = 2L;

    @Override
    public void process(CodecContext context) {
        Checker checker;
        Class<?> protocolClass = context.getProtocolClass();
        byte[] datagram = context.getDatagram();
        if (protocolClass.isAnnotationPresent(EnableChecksum.class) && !(checker = Checker.getInstance(protocolClass.getAnnotation(EnableChecksum.class))).validate(datagram, protocolClass)) {
            throw new CheckSumException(CodecError.ILLEGAL_CHECK_SUM);
        }
        this.nextFlow(context);
    }

    @Override
    public long getFlowCode() {
        return 2L;
    }
}

