/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.pipeline.encode;

import java.text.MessageFormat;
import java.util.List;
import java.util.function.Consumer;
import org.indunet.fastproto.TypeAssist;
import org.indunet.fastproto.encoder.EncodeContext;
import org.indunet.fastproto.encoder.EncoderFactory;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.exception.EncodeException;
import org.indunet.fastproto.pipeline.AbstractFlow;
import org.indunet.fastproto.pipeline.CodecContext;

public class EncodeFlow
extends AbstractFlow<CodecContext> {
    public static final long FLOW_CODE = 512L;

    @Override
    public void process(CodecContext context) {
        TypeAssist assist = context.getTypeAssist();
        Object object = context.getObject();
        byte[] datagram = context.getDatagram();
        List<EncodeContext> encodeContexts = assist.toEncodeContexts(object, datagram);
        encodeContexts.stream().forEach(c -> {
            TypeAssist a = c.getTypeAssist();
            try {
                if (a.getEncodeFormula() != null) {
                    Object o = EncoderFactory.getFormula(c.getTypeAssist().getEncodeFormula()).apply(c.getValue());
                    c.setValue(o);
                }
                Consumer<EncodeContext> consumer = EncoderFactory.getEncoder(c.getTypeAssist().getEncoderClass());
                consumer.accept((EncodeContext)c);
            }
            catch (EncodeException e) {
                throw new EncodeException(MessageFormat.format(CodecError.FAIL_ENCODING_FIELD.getMessage(), a.getField().toString()), (Throwable)e);
            }
        });
        this.nextFlow(context);
    }

    @Override
    public long getFlowCode() {
        return 512L;
    }
}

