/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.indunet.fastproto.CodecFeature;
import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.ProtocolType;
import org.indunet.fastproto.annotation.DecodeIgnore;
import org.indunet.fastproto.annotation.Decoder;
import org.indunet.fastproto.annotation.EnableChecksum;
import org.indunet.fastproto.annotation.EnableCompress;
import org.indunet.fastproto.annotation.EnableCrypto;
import org.indunet.fastproto.annotation.EnableProtocolVersion;
import org.indunet.fastproto.annotation.EncodeIgnore;
import org.indunet.fastproto.annotation.Encoder;
import org.indunet.fastproto.annotation.Endian;
import org.indunet.fastproto.annotation.TypeFlag;
import org.indunet.fastproto.annotation.type.AutoType;
import org.indunet.fastproto.decoder.DecodeContext;
import org.indunet.fastproto.decoder.TypeDecoder;
import org.indunet.fastproto.encoder.EncodeContext;
import org.indunet.fastproto.encoder.TypeEncoder;
import org.indunet.fastproto.exception.AddressingException;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.exception.CodecException;
import org.indunet.fastproto.exception.CryptoException;
import org.indunet.fastproto.exception.DecodeException;
import org.indunet.fastproto.exception.DecodeFormulaException;
import org.indunet.fastproto.exception.EncodeException;
import org.indunet.fastproto.pipeline.AbstractFlow;
import org.indunet.fastproto.pipeline.ValidationContext;
import org.indunet.fastproto.util.TypeUtils;

public class TypeAssist {
    protected static ConcurrentHashMap<Class<?>, TypeAssist> typeAssists = new ConcurrentHashMap();
    protected static final ThreadLocal<Object> instance = new ThreadLocal();
    protected static final ThreadLocal<Map<Class<?>, Object>> objects = new ThreadLocal();
    protected static final ThreadLocal<Set<Class<?>>> protocolClasses = new ThreadLocal();
    TypeAssist parent;
    Class<?> clazz;
    Field field;
    Annotation typeAnnotation;
    EndianPolicy endianPolicy;
    Boolean decodeIgnore;
    Boolean encodeIgnore;
    ElementType elementType;
    List<TypeAssist> elements;
    Class<? extends TypeDecoder> decoderClass;
    Class<? extends TypeEncoder> encoderClass;
    Class<? extends Function> decodeFormula;
    Class<? extends Function> encodeFormula;
    Function<DecodeContext, ?> decoder;
    Consumer<?> encoder;
    Integer minLength = 0;
    Optional<EnableCrypto> opEnableCrypto;
    Optional<byte[]> opKey;
    Optional<EnableCompress> opEnableCompress;
    Optional<EnableProtocolVersion> opProtocolVersion;
    Optional<EnableChecksum> opChecksum;
    Boolean circularReference = false;
    long codecFeature;

    protected TypeAssist() {
    }

    public static TypeAssist byClass(Class<?> protocolClass) {
        return typeAssists.computeIfAbsent(protocolClass, c -> TypeAssist.get(c));
    }

    public static TypeAssist get(@NonNull Class<?> protocolClass) {
        if (protocolClass == null) {
            throw new NullPointerException("protocolClass is marked non-null but is null");
        }
        protocolClasses.set(new HashSet());
        TypeAssist assist = TypeAssist.of(protocolClass);
        Optional<EnableCrypto> opEnableCrypto = Optional.of(protocolClass).map(c -> c.getAnnotation(EnableCrypto.class));
        assist.setOpEnableCrypto(opEnableCrypto);
        if (opEnableCrypto.isPresent()) {
            assist.setOpEnableCrypto(opEnableCrypto);
            if (!opEnableCrypto.get().key().isEmpty()) {
                assist.setOpKey(opEnableCrypto.map(EnableCrypto::key).map(String::getBytes));
            } else if (opEnableCrypto.get().keySupplier().length != 0) {
                assist.setOpKey(opEnableCrypto.map(EnableCrypto::keySupplier).map(a -> {
                    try {
                        Class c = a[0];
                        return (byte[])((Supplier)c.newInstance()).get();
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        throw new CryptoException(CodecError.INVALID_CRYPTO_KEY_SUPPLIER, (Throwable)e);
                    }
                }));
            } else {
                throw new CryptoException(CodecError.NO_CRYPTO_KEY);
            }
        }
        assist.setOpEnableCompress(Optional.of(protocolClass).map(c -> c.getAnnotation(EnableCompress.class)));
        assist.setOpProtocolVersion(Optional.of(protocolClass).map(c -> c.getAnnotation(EnableProtocolVersion.class)));
        assist.setOpChecksum(Optional.of(protocolClass).map(c -> c.getAnnotation(EnableChecksum.class)));
        assist.setCodecFeature(CodecFeature.of(assist));
        protocolClasses.remove();
        return assist;
    }

    protected static TypeAssist of(@NonNull Class<?> protocolClass) {
        if (protocolClass == null) {
            throw new NullPointerException("protocolClass is marked non-null but is null");
        }
        protocolClasses.get().add(protocolClass);
        Predicate<Field> isType = f -> Arrays.stream(f.getAnnotations()).map(Annotation::annotationType).anyMatch(t -> t.isAnnotationPresent(TypeFlag.class));
        Stream<TypeAssist> typeStream = Arrays.stream(protocolClass.getDeclaredFields()).filter(f -> !f.isAnnotationPresent(DecodeIgnore.class) && !f.isAnnotationPresent(EncodeIgnore.class)).filter(isType.negate()).filter(f -> !f.getType().isEnum()).filter(f -> !Modifier.isFinal(f.getModifiers())).filter(f -> !Modifier.isTransient(f.getModifiers())).filter(f -> !f.getType().isArray()).filter(f -> Arrays.stream(ProtocolType.supportedTypes()).noneMatch(t -> t == f.getType())).map(f -> {
            f.setAccessible(true);
            Class<?> c = f.getType();
            if (protocolClasses.get().contains(c)) {
                Boolean decodeIgnore = f.isAnnotationPresent(DecodeIgnore.class);
                return TypeAssist.builder().clazz(c).field((Field)f).typeAnnotation(null).decoderClass(null).encoderClass(null).decodeFormula(null).encodeFormula(null).endianPolicy(EndianPolicy.LITTLE).decodeIgnore(decodeIgnore).encodeIgnore(true).elementType(ElementType.TYPE).circularReference(true).elements(new ArrayList<TypeAssist>()).minLength(0).build();
            }
            TypeAssist a = TypeAssist.of(c);
            Boolean decodeIgnore = f.isAnnotationPresent(DecodeIgnore.class);
            Boolean encodeIgnore = f.isAnnotationPresent(EncodeIgnore.class);
            a.setDecodeIgnore(decodeIgnore);
            a.setEncodeIgnore(encodeIgnore);
            a.setField((Field)f);
            a.setCircularReference(false);
            return a;
        }).filter(a -> a.hasElement() || a.getCircularReference() != false);
        EndianPolicy endianPolicy = Optional.ofNullable(protocolClass.getAnnotation(Endian.class)).map(Endian::value).orElse(EndianPolicy.LITTLE);
        Boolean decodeIgnore = protocolClass.isAnnotationPresent(DecodeIgnore.class);
        Boolean encodeIgnore = protocolClass.isAnnotationPresent(EncodeIgnore.class);
        Stream<TypeAssist> fieldStream = Arrays.stream(protocolClass.getDeclaredFields()).filter(f -> !f.isAnnotationPresent(DecodeIgnore.class) && !f.isAnnotationPresent(EncodeIgnore.class)).filter(isType).peek(f -> f.setAccessible(true)).map(TypeAssist::of).peek(a -> {
            if (a.getEndianPolicy() == null) {
                a.setEndianPolicy(endianPolicy);
            }
        });
        TypeAssist assist = TypeAssist.builder().clazz(protocolClass).field(null).typeAnnotation(null).decoderClass(null).encoderClass(null).decodeFormula(null).encodeFormula(null).endianPolicy(endianPolicy).decodeIgnore(decodeIgnore).encodeIgnore(encodeIgnore).elementType(ElementType.TYPE).circularReference(false).minLength(0).build();
        List<TypeAssist> elements = Stream.concat(fieldStream, typeStream).peek(a -> a.setParent(assist)).collect(Collectors.toList());
        assist.setElements(elements);
        return assist;
    }

    public static Integer getLength(Annotation typeAnnotation) {
        if (typeAnnotation == null) {
            return null;
        }
        int minLength = 0;
        int value = TypeUtils.byteOffset(typeAnnotation);
        if (value >= 0) {
            minLength += value;
        } else {
            return -1;
        }
        int size = TypeUtils.size(typeAnnotation);
        minLength += size;
        int length = TypeUtils.length(typeAnnotation);
        if (length < 0) {
            return -1;
        }
        return minLength += length;
    }

    protected static Class<? extends Annotation> getTypeAnnotationClass(@NonNull Field field) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        Annotation typeAnnotation = TypeAssist.getTypeAnnotation(field);
        if (typeAnnotation instanceof AutoType) {
            return ProtocolType.byAutoType(field.getType()).typeAnnotationClass;
        }
        return typeAnnotation.annotationType();
    }

    protected static Annotation getTypeAnnotation(@NonNull Field field) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        return Arrays.stream(field.getAnnotations()).filter(a -> a.annotationType().isAnnotationPresent(TypeFlag.class)).findAny().orElseThrow(CodecException::new);
    }

    protected static Annotation getProxyTypeAnnotation(@NonNull Field field) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        Annotation typeAnnotation = TypeAssist.getTypeAnnotation(field);
        if (typeAnnotation instanceof AutoType) {
            Class<? extends Annotation> typeAnnotationClass = ProtocolType.byAutoType(field.getType()).typeAnnotationClass;
            return typeAnnotationClass.cast(Proxy.newProxyInstance(ClassLoader.getSystemClassLoader(), new Class[]{typeAnnotationClass}, (object, method, parameters) -> Arrays.stream(typeAnnotation.annotationType().getMethods()).filter(m -> m.getName().equals(method.getName())).findAny().orElseThrow(CodecException::new).invoke((Object)typeAnnotation, new Object[0])));
        }
        return typeAnnotation;
    }

    protected static TypeAssist of(Field field) {
        EndianPolicy policy = Optional.ofNullable(field.getAnnotation(Endian.class)).map(Endian::value).orElse(null);
        Boolean decodeIgnore = field.isAnnotationPresent(DecodeIgnore.class) || Modifier.isFinal(field.getModifiers());
        Boolean encodeIgnore = field.isAnnotationPresent(EncodeIgnore.class);
        Class<? extends Annotation> typeAnnotationClass = TypeAssist.getTypeAnnotationClass(field);
        Annotation typeAnnotation = TypeAssist.getTypeAnnotation(field);
        Class decoder = Optional.of(typeAnnotationClass).map(t -> t.getAnnotation(Decoder.class)).map(Decoder::value).orElse(null);
        Class encoder = Optional.of(typeAnnotationClass).map(t -> t.getAnnotation(Encoder.class)).map(Encoder::value).orElse(null);
        Function<String, Class> formula = name -> {
            try {
                Method method = typeAnnotation.getClass().getMethod((String)name, new Class[0]);
                Object array = method.invoke((Object)typeAnnotation, new Object[0]);
                return Optional.of(array).filter(a -> a.getClass().isArray()).filter(a -> Array.getLength(a) >= 1).map(a -> Array.get(a, 0)).map(o -> (Class)o).orElse(null);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
                throw new DecodeFormulaException(MessageFormat.format(CodecError.FAIL_GETTING_DECODE_FORMULA.getMessage(), typeAnnotation.annotationType().getName(), field.getName()), (Throwable)e);
            }
        };
        Class afterDecode = formula.apply("afterDecode");
        Class beforeEncode = formula.apply("beforeEncode");
        ValidationContext context = ValidationContext.builder().field(field).typeAnnotation(typeAnnotation).typeAnnotationClass(typeAnnotationClass).build();
        AbstractFlow.getValidateFlow().process(context);
        return TypeAssist.builder().clazz(field.getType()).field(field).typeAnnotation(TypeAssist.getProxyTypeAnnotation(field)).decoderClass(decoder).encoderClass(encoder).decodeFormula(afterDecode).encodeFormula(beforeEncode).endianPolicy(policy).decodeIgnore(decodeIgnore).encodeIgnore(encodeIgnore).elementType(ElementType.FIELD).circularReference(false).minLength(TypeAssist.getLength(TypeAssist.getProxyTypeAnnotation(field))).build();
    }

    public Integer getMaxLength() {
        Integer length = this.minLength;
        if (this.elements == null) {
            return length;
        }
        if (this.elements.stream().mapToInt(TypeAssist::getMaxLength).anyMatch(l -> l < 0)) {
            throw new AddressingException(CodecError.UNABLE_INFER_LENGTH);
        }
        int max = this.elements.stream().mapToInt(TypeAssist::getMaxLength).max().getAsInt();
        return length >= max ? length : max;
    }

    public <T> T getObject(Class<T> clazz) {
        Object object = instance.get();
        instance.remove();
        return (T)object;
    }

    public boolean hasElement() {
        return this.elements != null && !this.elements.isEmpty();
    }

    public void setValue(Object object, Object value) {
        try {
            this.field.set(object, value);
        }
        catch (IllegalAccessException e) {
            throw new DecodeException(MessageFormat.format(CodecError.FAIL_ASSIGN_VALUE.getMessage(), this.field.getName()), (Throwable)e);
        }
    }

    protected DecodeContext toDecodeContext(byte[] datagram, Object object) {
        return DecodeContext.builder().object(object).datagram(datagram).typeAssist(this).build();
    }

    protected List<DecodeContext> toDecodeContexts(byte[] datagram, Object parent) {
        try {
            Object value;
            if (objects.get().containsKey(this.clazz)) {
                value = objects.get().get(this.clazz);
            } else {
                value = this.clazz.newInstance();
                objects.get().put(this.clazz, value);
            }
            if (parent == null) {
                instance.set(value);
            }
            if (parent != null && this.field != null) {
                try {
                    this.field.set(parent, value);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            Stream<DecodeContext> fieldStream = this.elements.stream().filter(a -> a.getElementType() == ElementType.FIELD).map(a -> a.toDecodeContext(datagram, value));
            Stream classStream = this.elements.stream().filter(a -> a.getElementType() == ElementType.TYPE).flatMap(a -> a.toDecodeContexts(datagram, value).stream());
            return Stream.concat(fieldStream, classStream).collect(Collectors.toList());
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            throw new DecodeException(MessageFormat.format(CodecError.FAIL_INITIALIZING_DECODE_OBJECT.getMessage(), this.clazz.getName()), (Throwable)e);
        }
    }

    public List<DecodeContext> toDecodeContexts(byte[] datagram) {
        objects.set(new HashMap());
        List<DecodeContext> contexts = this.toDecodeContexts(datagram, null);
        objects.remove();
        return contexts;
    }

    public EncodeContext toEncodeContext(Object object, byte[] datagram) {
        try {
            return EncodeContext.builder().datagram(datagram).typeAssist(this).value(this.field.get(object)).build();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new EncodeException(MessageFormat.format(CodecError.FAIL_GETTING_FIELD_VALUE.getMessage(), this.field.getName()), (Throwable)e);
        }
    }

    public List<EncodeContext> toEncodeContexts(Object object, byte[] datagram) {
        Stream<EncodeContext> fieldStream = this.elements.stream().filter(a -> a.getElementType() == ElementType.FIELD).map(a -> a.toEncodeContext(object, datagram));
        Stream classStream = this.elements.stream().filter(a -> a.getElementType() == ElementType.TYPE).flatMap(a -> {
            try {
                if (object != null && a.field.get(object) != null) {
                    return a.toEncodeContexts(a.field.get(object), datagram).stream();
                }
                return Stream.empty();
            }
            catch (IllegalAccessException e) {
                throw new DecodeException(MessageFormat.format(CodecError.FAIL_GETTING_FIELD_VALUE.getMessage(), this.clazz.getName()), (Throwable)e);
            }
        });
        return Stream.concat(fieldStream, classStream).filter(c -> c.getValue() != null).collect(Collectors.toList());
    }

    public static TypeAssistBuilder builder() {
        return new TypeAssistBuilder();
    }

    public TypeAssist getParent() {
        return this.parent;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public Field getField() {
        return this.field;
    }

    public Annotation getTypeAnnotation() {
        return this.typeAnnotation;
    }

    public EndianPolicy getEndianPolicy() {
        return this.endianPolicy;
    }

    public Boolean getDecodeIgnore() {
        return this.decodeIgnore;
    }

    public Boolean getEncodeIgnore() {
        return this.encodeIgnore;
    }

    public ElementType getElementType() {
        return this.elementType;
    }

    public List<TypeAssist> getElements() {
        return this.elements;
    }

    public Class<? extends TypeDecoder> getDecoderClass() {
        return this.decoderClass;
    }

    public Class<? extends TypeEncoder> getEncoderClass() {
        return this.encoderClass;
    }

    public Class<? extends Function> getDecodeFormula() {
        return this.decodeFormula;
    }

    public Class<? extends Function> getEncodeFormula() {
        return this.encodeFormula;
    }

    public Function<DecodeContext, ?> getDecoder() {
        return this.decoder;
    }

    public Consumer<?> getEncoder() {
        return this.encoder;
    }

    public Integer getMinLength() {
        return this.minLength;
    }

    public Optional<EnableCrypto> getOpEnableCrypto() {
        return this.opEnableCrypto;
    }

    public Optional<byte[]> getOpKey() {
        return this.opKey;
    }

    public Optional<EnableCompress> getOpEnableCompress() {
        return this.opEnableCompress;
    }

    public Optional<EnableProtocolVersion> getOpProtocolVersion() {
        return this.opProtocolVersion;
    }

    public Optional<EnableChecksum> getOpChecksum() {
        return this.opChecksum;
    }

    public Boolean getCircularReference() {
        return this.circularReference;
    }

    public long getCodecFeature() {
        return this.codecFeature;
    }

    public void setParent(TypeAssist parent) {
        this.parent = parent;
    }

    public void setClazz(Class<?> clazz) {
        this.clazz = clazz;
    }

    public void setField(Field field) {
        this.field = field;
    }

    public void setTypeAnnotation(Annotation typeAnnotation) {
        this.typeAnnotation = typeAnnotation;
    }

    public void setEndianPolicy(EndianPolicy endianPolicy) {
        this.endianPolicy = endianPolicy;
    }

    public void setDecodeIgnore(Boolean decodeIgnore) {
        this.decodeIgnore = decodeIgnore;
    }

    public void setEncodeIgnore(Boolean encodeIgnore) {
        this.encodeIgnore = encodeIgnore;
    }

    public void setElementType(ElementType elementType) {
        this.elementType = elementType;
    }

    public void setElements(List<TypeAssist> elements) {
        this.elements = elements;
    }

    public void setDecoderClass(Class<? extends TypeDecoder> decoderClass) {
        this.decoderClass = decoderClass;
    }

    public void setEncoderClass(Class<? extends TypeEncoder> encoderClass) {
        this.encoderClass = encoderClass;
    }

    public void setDecodeFormula(Class<? extends Function> decodeFormula) {
        this.decodeFormula = decodeFormula;
    }

    public void setEncodeFormula(Class<? extends Function> encodeFormula) {
        this.encodeFormula = encodeFormula;
    }

    public void setDecoder(Function<DecodeContext, ?> decoder) {
        this.decoder = decoder;
    }

    public void setEncoder(Consumer<?> encoder) {
        this.encoder = encoder;
    }

    public void setMinLength(Integer minLength) {
        this.minLength = minLength;
    }

    public void setOpEnableCrypto(Optional<EnableCrypto> opEnableCrypto) {
        this.opEnableCrypto = opEnableCrypto;
    }

    public void setOpKey(Optional<byte[]> opKey) {
        this.opKey = opKey;
    }

    public void setOpEnableCompress(Optional<EnableCompress> opEnableCompress) {
        this.opEnableCompress = opEnableCompress;
    }

    public void setOpProtocolVersion(Optional<EnableProtocolVersion> opProtocolVersion) {
        this.opProtocolVersion = opProtocolVersion;
    }

    public void setOpChecksum(Optional<EnableChecksum> opChecksum) {
        this.opChecksum = opChecksum;
    }

    public void setCircularReference(Boolean circularReference) {
        this.circularReference = circularReference;
    }

    public void setCodecFeature(long codecFeature) {
        this.codecFeature = codecFeature;
    }

    public TypeAssist(TypeAssist parent, Class<?> clazz, Field field, Annotation typeAnnotation, EndianPolicy endianPolicy, Boolean decodeIgnore, Boolean encodeIgnore, ElementType elementType, List<TypeAssist> elements, Class<? extends TypeDecoder> decoderClass, Class<? extends TypeEncoder> encoderClass, Class<? extends Function> decodeFormula, Class<? extends Function> encodeFormula, Function<DecodeContext, ?> decoder, Consumer<?> encoder, Integer minLength, Optional<EnableCrypto> opEnableCrypto, Optional<byte[]> opKey, Optional<EnableCompress> opEnableCompress, Optional<EnableProtocolVersion> opProtocolVersion, Optional<EnableChecksum> opChecksum, Boolean circularReference, long codecFeature) {
        this.parent = parent;
        this.clazz = clazz;
        this.field = field;
        this.typeAnnotation = typeAnnotation;
        this.endianPolicy = endianPolicy;
        this.decodeIgnore = decodeIgnore;
        this.encodeIgnore = encodeIgnore;
        this.elementType = elementType;
        this.elements = elements;
        this.decoderClass = decoderClass;
        this.encoderClass = encoderClass;
        this.decodeFormula = decodeFormula;
        this.encodeFormula = encodeFormula;
        this.decoder = decoder;
        this.encoder = encoder;
        this.minLength = minLength;
        this.opEnableCrypto = opEnableCrypto;
        this.opKey = opKey;
        this.opEnableCompress = opEnableCompress;
        this.opProtocolVersion = opProtocolVersion;
        this.opChecksum = opChecksum;
        this.circularReference = circularReference;
        this.codecFeature = codecFeature;
    }

    public static class TypeAssistBuilder {
        private TypeAssist parent;
        private Class<?> clazz;
        private Field field;
        private Annotation typeAnnotation;
        private EndianPolicy endianPolicy;
        private Boolean decodeIgnore;
        private Boolean encodeIgnore;
        private ElementType elementType;
        private List<TypeAssist> elements;
        private Class<? extends TypeDecoder> decoderClass;
        private Class<? extends TypeEncoder> encoderClass;
        private Class<? extends Function> decodeFormula;
        private Class<? extends Function> encodeFormula;
        private Function<DecodeContext, ?> decoder;
        private Consumer<?> encoder;
        private Integer minLength;
        private Optional<EnableCrypto> opEnableCrypto;
        private Optional<byte[]> opKey;
        private Optional<EnableCompress> opEnableCompress;
        private Optional<EnableProtocolVersion> opProtocolVersion;
        private Optional<EnableChecksum> opChecksum;
        private Boolean circularReference;
        private long codecFeature;

        TypeAssistBuilder() {
        }

        public TypeAssistBuilder parent(TypeAssist parent) {
            this.parent = parent;
            return this;
        }

        public TypeAssistBuilder clazz(Class<?> clazz) {
            this.clazz = clazz;
            return this;
        }

        public TypeAssistBuilder field(Field field) {
            this.field = field;
            return this;
        }

        public TypeAssistBuilder typeAnnotation(Annotation typeAnnotation) {
            this.typeAnnotation = typeAnnotation;
            return this;
        }

        public TypeAssistBuilder endianPolicy(EndianPolicy endianPolicy) {
            this.endianPolicy = endianPolicy;
            return this;
        }

        public TypeAssistBuilder decodeIgnore(Boolean decodeIgnore) {
            this.decodeIgnore = decodeIgnore;
            return this;
        }

        public TypeAssistBuilder encodeIgnore(Boolean encodeIgnore) {
            this.encodeIgnore = encodeIgnore;
            return this;
        }

        public TypeAssistBuilder elementType(ElementType elementType) {
            this.elementType = elementType;
            return this;
        }

        public TypeAssistBuilder elements(List<TypeAssist> elements) {
            this.elements = elements;
            return this;
        }

        public TypeAssistBuilder decoderClass(Class<? extends TypeDecoder> decoderClass) {
            this.decoderClass = decoderClass;
            return this;
        }

        public TypeAssistBuilder encoderClass(Class<? extends TypeEncoder> encoderClass) {
            this.encoderClass = encoderClass;
            return this;
        }

        public TypeAssistBuilder decodeFormula(Class<? extends Function> decodeFormula) {
            this.decodeFormula = decodeFormula;
            return this;
        }

        public TypeAssistBuilder encodeFormula(Class<? extends Function> encodeFormula) {
            this.encodeFormula = encodeFormula;
            return this;
        }

        public TypeAssistBuilder decoder(Function<DecodeContext, ?> decoder) {
            this.decoder = decoder;
            return this;
        }

        public TypeAssistBuilder encoder(Consumer<?> encoder) {
            this.encoder = encoder;
            return this;
        }

        public TypeAssistBuilder minLength(Integer minLength) {
            this.minLength = minLength;
            return this;
        }

        public TypeAssistBuilder opEnableCrypto(Optional<EnableCrypto> opEnableCrypto) {
            this.opEnableCrypto = opEnableCrypto;
            return this;
        }

        public TypeAssistBuilder opKey(Optional<byte[]> opKey) {
            this.opKey = opKey;
            return this;
        }

        public TypeAssistBuilder opEnableCompress(Optional<EnableCompress> opEnableCompress) {
            this.opEnableCompress = opEnableCompress;
            return this;
        }

        public TypeAssistBuilder opProtocolVersion(Optional<EnableProtocolVersion> opProtocolVersion) {
            this.opProtocolVersion = opProtocolVersion;
            return this;
        }

        public TypeAssistBuilder opChecksum(Optional<EnableChecksum> opChecksum) {
            this.opChecksum = opChecksum;
            return this;
        }

        public TypeAssistBuilder circularReference(Boolean circularReference) {
            this.circularReference = circularReference;
            return this;
        }

        public TypeAssistBuilder codecFeature(long codecFeature) {
            this.codecFeature = codecFeature;
            return this;
        }

        public TypeAssist build() {
            return new TypeAssist(this.parent, this.clazz, this.field, this.typeAnnotation, this.endianPolicy, this.decodeIgnore, this.encodeIgnore, this.elementType, this.elements, this.decoderClass, this.encoderClass, this.decodeFormula, this.encodeFormula, this.decoder, this.encoder, this.minLength, this.opEnableCrypto, this.opKey, this.opEnableCompress, this.opProtocolVersion, this.opChecksum, this.circularReference, this.codecFeature);
        }

        public String toString() {
            return "TypeAssist.TypeAssistBuilder(parent=" + this.parent + ", clazz=" + this.clazz + ", field=" + this.field + ", typeAnnotation=" + this.typeAnnotation + ", endianPolicy=" + (Object)((Object)this.endianPolicy) + ", decodeIgnore=" + this.decodeIgnore + ", encodeIgnore=" + this.encodeIgnore + ", elementType=" + (Object)((Object)this.elementType) + ", elements=" + this.elements + ", decoderClass=" + this.decoderClass + ", encoderClass=" + this.encoderClass + ", decodeFormula=" + this.decodeFormula + ", encodeFormula=" + this.encodeFormula + ", decoder=" + this.decoder + ", encoder=" + this.encoder + ", minLength=" + this.minLength + ", opEnableCrypto=" + this.opEnableCrypto + ", opKey=" + this.opKey + ", opEnableCompress=" + this.opEnableCompress + ", opProtocolVersion=" + this.opProtocolVersion + ", opChecksum=" + this.opChecksum + ", circularReference=" + this.circularReference + ", codecFeature=" + this.codecFeature + ")";
        }
    }
}

