/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.checksum;

import lombok.NonNull;
import org.indunet.fastproto.annotation.EnableChecksum;
import org.indunet.fastproto.checksum.CheckPolicy;
import org.indunet.fastproto.checksum.Crc16Checker;
import org.indunet.fastproto.checksum.Crc32Checker;
import org.indunet.fastproto.checksum.Crc8Checker;

public interface Checker {
    public boolean validate(byte[] var1, Class<?> var2);

    public void setValue(byte[] var1, Class<?> var2);

    public int getSize();

    public static Checker getInstance(@NonNull EnableChecksum checkSum) {
        if (checkSum == null) {
            throw new NullPointerException("checkSum is marked non-null but is null");
        }
        CheckPolicy policy = checkSum.checkPolicy();
        int poly = checkSum.poly();
        switch (policy) {
            case CRC8: {
                return Crc8Checker.getInstance(poly);
            }
            case CRC8_CCITT: {
                return Crc8Checker.getInstance(policy.getPoly());
            }
            case CRC16: {
                return Crc16Checker.getInstance(poly);
            }
            case CRC16_CCITT: {
                return Crc16Checker.getInstance(policy.getPoly());
            }
            case CRC32: {
                return Crc32Checker.getInstance();
            }
        }
        return Crc16Checker.getInstance();
    }
}

