/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.compress;

import java.util.Arrays;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.exception.CompressException;

public enum CompressPolicy {
    GZIP(1, "gzip"),
    DEFLATE(2, "deflate");

    int code;
    String name;

    public static CompressPolicy byName(String name) {
        return Arrays.stream(CompressPolicy.values()).filter(p -> p.getName().equals(name)).findFirst().orElseThrow(() -> new CompressException(CodecError.INVALID_COMPRESS_POLICY));
    }

    private CompressPolicy(int code, String name) {
        this.code = code;
        this.name = name;
    }

    public int getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }
}

