/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.decoder;

import lombok.NonNull;
import org.indunet.fastproto.annotation.type.BinaryType;
import org.indunet.fastproto.decoder.DecodeContext;
import org.indunet.fastproto.decoder.TypeDecoder;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.exception.DecodeException;
import org.indunet.fastproto.exception.OutOfBoundsException;
import org.indunet.fastproto.util.ReverseUtils;

public class BinaryDecoder
implements TypeDecoder<byte[]> {
    @Override
    public byte[] decode(@NonNull DecodeContext context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        BinaryType type = context.getTypeAnnotation(BinaryType.class);
        return this.decode(context.getDatagram(), type.value(), type.length());
    }

    public byte[] decode(@NonNull byte[] datagram, int byteOffset, int length) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        int bo = ReverseUtils.byteOffset(datagram.length, byteOffset);
        int l = ReverseUtils.length(datagram.length, byteOffset, length);
        if (bo < 0) {
            throw new DecodeException(CodecError.ILLEGAL_BYTE_OFFSET);
        }
        if (bo >= datagram.length) {
            throw new DecodeException(CodecError.ILLEGAL_BYTE_OFFSET);
        }
        if (l <= 0) {
            throw new DecodeException(CodecError.ILLEGAL_PARAMETER);
        }
        if (bo + l > datagram.length) {
            throw new OutOfBoundsException(CodecError.EXCEEDED_DATAGRAM_SIZE);
        }
        byte[] bytes = new byte[l];
        System.arraycopy(datagram, bo, bytes, 0, l);
        return bytes;
    }
}

