/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.decoder;

import lombok.NonNull;
import org.indunet.fastproto.annotation.type.ByteType;
import org.indunet.fastproto.decoder.DecodeContext;
import org.indunet.fastproto.decoder.TypeDecoder;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.exception.DecodeException;
import org.indunet.fastproto.exception.OutOfBoundsException;
import org.indunet.fastproto.util.ReverseUtils;

public class ByteDecoder
implements TypeDecoder<Byte> {
    @Override
    public Byte decode(DecodeContext context) {
        ByteType type = context.getTypeAnnotation(ByteType.class);
        return this.decode(context.getDatagram(), type.value());
    }

    public byte decode(@NonNull byte[] datagram, int byteOffset) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        int bo = ReverseUtils.byteOffset(datagram.length, byteOffset);
        if (bo < 0) {
            throw new DecodeException(CodecError.ILLEGAL_BYTE_OFFSET);
        }
        if (bo + 1 > datagram.length) {
            throw new OutOfBoundsException(CodecError.EXCEEDED_DATAGRAM_SIZE);
        }
        return datagram[bo];
    }
}

