/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.decoder;

import lombok.NonNull;
import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.annotation.type.FloatType;
import org.indunet.fastproto.decoder.DecodeContext;
import org.indunet.fastproto.decoder.TypeDecoder;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.exception.DecodeException;
import org.indunet.fastproto.exception.OutOfBoundsException;
import org.indunet.fastproto.util.ReverseUtils;

public class FloatDecoder
implements TypeDecoder<Float> {
    @Override
    public Float decode(DecodeContext context) {
        FloatType type = context.getTypeAnnotation(FloatType.class);
        return Float.valueOf(this.decode(context.getDatagram(), type.value(), context.getEndianPolicy()));
    }

    public float decode(@NonNull byte[] datagram, int byteOffset, @NonNull EndianPolicy endian) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (endian == null) {
            throw new NullPointerException("endian is marked non-null but is null");
        }
        int bo = ReverseUtils.byteOffset(datagram.length, byteOffset);
        if (bo < 0) {
            throw new DecodeException(CodecError.ILLEGAL_BYTE_OFFSET);
        }
        if (bo + 4 > datagram.length) {
            throw new OutOfBoundsException(CodecError.EXCEEDED_DATAGRAM_SIZE);
        }
        int value = 0;
        if (endian == EndianPolicy.LITTLE) {
            value |= datagram[bo] & 0xFF;
            value |= (datagram[bo + 1] & 0xFF) << 8;
            value |= (datagram[bo + 2] & 0xFF) << 16;
            value |= (datagram[bo + 3] & 0xFF) << 24;
        } else if (endian == EndianPolicy.BIG) {
            value |= datagram[bo + 3] & 0xFF;
            value |= (datagram[bo + 2] & 0xFF) << 8;
            value |= (datagram[bo + 1] & 0xFF) << 16;
            value |= (datagram[bo] & 0xFF) << 24;
        }
        return Float.intBitsToFloat(value);
    }
}

