/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.decoder;

import lombok.NonNull;
import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.annotation.type.LongType;
import org.indunet.fastproto.decoder.DecodeContext;
import org.indunet.fastproto.decoder.TypeDecoder;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.exception.DecodeException;
import org.indunet.fastproto.exception.OutOfBoundsException;
import org.indunet.fastproto.util.ReverseUtils;

public class LongDecoder
implements TypeDecoder<Long> {
    @Override
    public Long decode(@NonNull DecodeContext context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        LongType type = context.getTypeAnnotation(LongType.class);
        return this.decode(context.getDatagram(), type.value(), context.getEndianPolicy());
    }

    public long decode(@NonNull byte[] datagram, int byteOffset, @NonNull EndianPolicy endian) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (endian == null) {
            throw new NullPointerException("endian is marked non-null but is null");
        }
        int bo = ReverseUtils.byteOffset(datagram.length, byteOffset);
        if (bo < 0) {
            throw new DecodeException(CodecError.ILLEGAL_BYTE_OFFSET);
        }
        if (bo + 8 > datagram.length) {
            throw new OutOfBoundsException(CodecError.EXCEEDED_DATAGRAM_SIZE);
        }
        long value = 0L;
        if (endian == EndianPolicy.LITTLE) {
            value |= (long)(datagram[bo] & 0xFF);
            value |= ((long)datagram[bo + 1] & 0xFFL) << 8;
            value |= ((long)datagram[bo + 2] & 0xFFL) << 16;
            value |= ((long)datagram[bo + 3] & 0xFFL) << 24;
            value |= ((long)datagram[bo + 4] & 0xFFL) << 32;
            value |= ((long)datagram[bo + 5] & 0xFFL) << 40;
            value |= ((long)datagram[bo + 6] & 0xFFL) << 48;
            value |= ((long)datagram[bo + 7] & 0xFFL) << 56;
        } else if (endian == EndianPolicy.BIG) {
            value |= (long)(datagram[bo + 7] & 0xFF);
            value |= ((long)datagram[bo + 6] & 0xFFL) << 8;
            value |= ((long)datagram[bo + 5] & 0xFFL) << 16;
            value |= ((long)datagram[bo + 4] & 0xFFL) << 24;
            value |= ((long)datagram[bo + 3] & 0xFFL) << 32;
            value |= ((long)datagram[bo + 2] & 0xFFL) << 40;
            value |= ((long)datagram[bo + 1] & 0xFFL) << 48;
            value |= ((long)datagram[bo] & 0xFFL) << 56;
        }
        return value;
    }
}

