/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.encoder;

import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.annotation.type.CharacterType;
import org.indunet.fastproto.encoder.EncodeContext;
import org.indunet.fastproto.encoder.TypeEncoder;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.exception.EncodeException;
import org.indunet.fastproto.exception.SpaceNotEnoughException;
import org.indunet.fastproto.util.ReverseUtils;

public class CharacterEncoder
implements TypeEncoder {
    @Override
    public void encode(EncodeContext context) {
        CharacterType type = context.getTypeAnnotation(CharacterType.class);
        Character value = context.getValue(Character.class);
        EndianPolicy policy = context.getEndianPolicy();
        this.encode(context.getDatagram(), type.value(), policy, value.charValue());
    }

    public void encode(byte[] datagram, int byteOffset, EndianPolicy policy, char value) {
        int bo = ReverseUtils.byteOffset(datagram.length, byteOffset);
        if (bo < 0) {
            throw new EncodeException(CodecError.ILLEGAL_BYTE_OFFSET);
        }
        if (bo + 2 > datagram.length) {
            throw new SpaceNotEnoughException(CodecError.EXCEEDED_DATAGRAM_SIZE);
        }
        if (policy == EndianPolicy.BIG) {
            int n = bo;
            datagram[n] = (byte)(datagram[n] | value >> 8 & 0xFF);
            int n2 = bo + 1;
            datagram[n2] = (byte)(datagram[n2] | value & 0xFF);
        } else {
            int n = bo + 1;
            datagram[n] = (byte)(datagram[n] | value >> 8 & 0xFF);
            int n3 = bo;
            datagram[n3] = (byte)(datagram[n3] | value & 0xFF);
        }
    }
}

