/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.encoder;

import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.annotation.type.DoubleType;
import org.indunet.fastproto.encoder.EncodeContext;
import org.indunet.fastproto.encoder.TypeEncoder;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.exception.EncodeException;
import org.indunet.fastproto.exception.SpaceNotEnoughException;
import org.indunet.fastproto.util.ReverseUtils;

public class DoubleEncoder
implements TypeEncoder {
    @Override
    public void encode(EncodeContext context) {
        DoubleType type = context.getTypeAnnotation(DoubleType.class);
        Double value = context.getValue(Double.class);
        this.encode(context.getDatagram(), type.value(), context.getEndianPolicy(), value);
    }

    public void encode(byte[] datagram, int byteOffset, EndianPolicy endian, double value) {
        int bo = ReverseUtils.byteOffset(datagram.length, byteOffset);
        if (bo < 0) {
            throw new EncodeException(CodecError.ILLEGAL_BYTE_OFFSET);
        }
        if (bo + 8 > datagram.length) {
            throw new SpaceNotEnoughException(CodecError.EXCEEDED_DATAGRAM_SIZE);
        }
        long bits = Double.doubleToLongBits(value);
        if (endian == EndianPolicy.BIG) {
            datagram[bo + 7] = (byte)(bits & 0xFFL);
            datagram[bo + 6] = (byte)(bits >> 8 & 0xFFL);
            datagram[bo + 5] = (byte)(bits >> 16 & 0xFFL);
            datagram[bo + 4] = (byte)(bits >> 24 & 0xFFL);
            datagram[bo + 3] = (byte)(bits >> 32 & 0xFFL);
            datagram[bo + 2] = (byte)(bits >> 40 & 0xFFL);
            datagram[bo + 1] = (byte)(bits >> 48 & 0xFFL);
            datagram[bo] = (byte)(bits >> 56 & 0xFFL);
        } else {
            datagram[bo] = (byte)(bits & 0xFFL);
            datagram[bo + 1] = (byte)(bits >> 8 & 0xFFL);
            datagram[bo + 2] = (byte)(bits >> 16 & 0xFFL);
            datagram[bo + 3] = (byte)(bits >> 24 & 0xFFL);
            datagram[bo + 4] = (byte)(bits >> 32 & 0xFFL);
            datagram[bo + 5] = (byte)(bits >> 40 & 0xFFL);
            datagram[bo + 6] = (byte)(bits >> 48 & 0xFFL);
            datagram[bo + 7] = (byte)(bits >> 56 & 0xFFL);
        }
    }
}

