/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.encoder;

import lombok.NonNull;
import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.annotation.type.IntegerType;
import org.indunet.fastproto.encoder.EncodeContext;
import org.indunet.fastproto.encoder.TypeEncoder;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.exception.EncodeException;
import org.indunet.fastproto.exception.SpaceNotEnoughException;
import org.indunet.fastproto.util.ReverseUtils;

public class IntegerEncoder
implements TypeEncoder {
    @Override
    public void encode(@NonNull EncodeContext context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        IntegerType type = context.getTypeAnnotation(IntegerType.class);
        Integer value = context.getValue(Integer.class);
        this.encode(context.getDatagram(), type.value(), context.getEndianPolicy(), value);
    }

    public void encode(@NonNull byte[] datagram, int byteOffset, @NonNull EndianPolicy policy, int value) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (policy == null) {
            throw new NullPointerException("policy is marked non-null but is null");
        }
        int bo = ReverseUtils.byteOffset(datagram.length, byteOffset);
        if (bo < 0) {
            throw new EncodeException(CodecError.ILLEGAL_BYTE_OFFSET);
        }
        if (bo + 4 > datagram.length) {
            throw new SpaceNotEnoughException(CodecError.EXCEEDED_DATAGRAM_SIZE);
        }
        if (policy == EndianPolicy.LITTLE) {
            datagram[bo] = (byte)(value & 0xFF);
            datagram[bo + 1] = (byte)(value >> 8 & 0xFF);
            datagram[bo + 2] = (byte)(value >> 16 & 0xFF);
            datagram[bo + 3] = (byte)(value >> 24 & 0xFF);
        } else if (policy == EndianPolicy.BIG) {
            datagram[bo + 3] = (byte)(value & 0xFF);
            datagram[bo + 2] = (byte)(value >> 8 & 0xFF);
            datagram[bo + 1] = (byte)(value >> 16 & 0xFF);
            datagram[bo] = (byte)(value >> 24 & 0xFF);
        }
    }
}

