/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.encoder;

import java.sql.Timestamp;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.ProtocolType;
import org.indunet.fastproto.annotation.type.TimestampType;
import org.indunet.fastproto.encoder.EncodeContext;
import org.indunet.fastproto.encoder.TypeEncoder;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.exception.EncodeException;
import org.indunet.fastproto.exception.SpaceNotEnoughException;
import org.indunet.fastproto.util.EncodeUtils;
import org.indunet.fastproto.util.ReverseUtils;

public class TimestampEncoder
implements TypeEncoder {
    @Override
    public void encode(@NonNull EncodeContext context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        EndianPolicy policy = context.getEndianPolicy();
        TimestampType type = context.getTypeAnnotation(TimestampType.class);
        Timestamp value = context.getValue(Timestamp.class);
        this.encode(context.getDatagram(), type.value(), type.protocolType(), policy, type.unit(), value);
    }

    public void encode(@NonNull byte[] datagram, int byteOffset, @NonNull ProtocolType dataType, @NonNull EndianPolicy policy, @NonNull TimeUnit unit, @NonNull Timestamp value) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (dataType == null) {
            throw new NullPointerException("dataType is marked non-null but is null");
        }
        if (policy == null) {
            throw new NullPointerException("policy is marked non-null but is null");
        }
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        int bo = ReverseUtils.byteOffset(datagram.length, byteOffset);
        if (bo < 0) {
            throw new EncodeException(CodecError.ILLEGAL_BYTE_OFFSET);
        }
        if (dataType == ProtocolType.LONG && unit == TimeUnit.MILLISECONDS) {
            if (bo + 8 > datagram.length) {
                throw new SpaceNotEnoughException(CodecError.EXCEEDED_DATAGRAM_SIZE);
            }
            EncodeUtils.longType(datagram, bo, policy, value.getTime());
        } else if (dataType == ProtocolType.UINTEGER32 && unit == TimeUnit.SECONDS) {
            if (bo + 4 > datagram.length) {
                throw new SpaceNotEnoughException(CodecError.EXCEEDED_DATAGRAM_SIZE);
            }
            EncodeUtils.integerType(datagram, bo, policy, (int)(value.getTime() / 1000L));
        } else {
            throw new EncodeException(CodecError.ILLEGAL_TIMESTAMP_PARAMETERS);
        }
    }
}

