/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;
import lombok.NonNull;
import org.indunet.fastproto.FastProto;

public class ProtoDecoder
extends ByteToMessageDecoder {
    Class<?> protocolClass;

    public ProtoDecoder(@NonNull Class<?> protocolClass) {
        if (protocolClass == null) {
            throw new NullPointerException("protocolClass is marked non-null but is null");
        }
        this.protocolClass = protocolClass;
    }

    protected void decode(ChannelHandlerContext context, ByteBuf byteBuf, List<Object> list) throws Exception {
        if (byteBuf.readableBytes() <= 0) {
            return;
        }
        byte[] datagram = new byte[4];
        ByteBuf bf = byteBuf.readBytes(4);
        bf.getBytes(bf.readerIndex(), datagram);
        Object object = FastProto.parseFrom(datagram, this.protocolClass);
        list.add(object);
    }
}

