/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.pipeline.decode;

import java.text.MessageFormat;
import java.util.List;
import java.util.function.Function;
import org.indunet.fastproto.TypeAssist;
import org.indunet.fastproto.decoder.DecodeContext;
import org.indunet.fastproto.decoder.DecoderFactory;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.exception.DecodeException;
import org.indunet.fastproto.pipeline.AbstractFlow;
import org.indunet.fastproto.pipeline.CodecContext;

public class DecodeFlow
extends AbstractFlow<CodecContext> {
    public static final long FLOW_CODE = 8L;

    @Override
    public void process(CodecContext context) {
        TypeAssist assist = context.getTypeAssist();
        byte[] datagram = context.getDatagram();
        Class<?> protocolClass = context.getProtocolClass();
        List<DecodeContext> decodeContexts = assist.toDecodeContexts(datagram);
        decodeContexts.stream().forEach(c -> {
            TypeAssist a = c.getTypeAssist();
            Function<DecodeContext, ?> func = DecoderFactory.getDecoder(a.getDecoderClass(), a.getDecodeFormula());
            try {
                Object value = func.apply((DecodeContext)c);
                Object o = c.getObject();
                a.setValue(o, value);
            }
            catch (DecodeException e) {
                throw new DecodeException(MessageFormat.format(CodecError.FAIL_DECODING_FIELD.getMessage(), a.getField().toString()), (Throwable)e);
            }
        });
        context.setObject(assist.getObject(protocolClass));
    }

    @Override
    public long getFlowCode() {
        return 8L;
    }
}

