/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.pipeline.validate;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.function.Function;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.exception.CodecException;
import org.indunet.fastproto.exception.DecodeFormulaException;
import org.indunet.fastproto.pipeline.AbstractFlow;
import org.indunet.fastproto.pipeline.ValidationContext;
import org.indunet.fastproto.util.TypeUtils;

public class FieldFlow
extends AbstractFlow<ValidationContext> {
    public static int FIELD_FLOW = 1;

    @Override
    public void process(ValidationContext context) {
        Class<? extends Function> encodeFormula;
        Class<? extends Function> decodeFormula;
        Annotation typeAnnotation = context.getTypeAnnotation();
        Class<? extends Annotation> typeAnnotationClass = context.getTypeAnnotationClass();
        Field field = context.getField();
        try {
            decodeFormula = TypeUtils.decodeFormula(typeAnnotation);
            encodeFormula = TypeUtils.encodeFormula(typeAnnotation);
            context.setDecodeFormula(decodeFormula);
            context.setEncodeFormula(encodeFormula);
        }
        catch (Exception e) {
            throw new DecodeFormulaException(MessageFormat.format(CodecError.FAIL_GETTING_DECODE_FORMULA.getMessage(), typeAnnotation.annotationType().getName(), field.getName()), (Throwable)e);
        }
        if (decodeFormula == null && encodeFormula == null) {
            Arrays.stream(TypeUtils.javaTypes(typeAnnotationClass)).filter(t -> t == field.getType() || field.getType().isEnum() && ((Class)t).isAssignableFrom(field.getType())).findAny().orElseThrow(() -> new CodecException(MessageFormat.format(CodecError.ANNOTATION_FIELD_NOT_MATCH.getMessage(), typeAnnotation.annotationType().getName(), field.getName())));
        }
        this.nextFlow(context);
    }

    @Override
    public long getFlowCode() {
        return FIELD_FLOW;
    }
}

