/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.Optional;
import java.util.function.Function;
import lombok.NonNull;
import org.indunet.fastproto.ProtocolType;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.exception.CodecException;

public class TypeUtils {
    protected static final String SIZE_NAME = "SIZE";
    protected static final String BYTE_OFFSET_NAME = "value";
    protected static final String LENGTH_NAME = "length";
    protected static final String PROTOCOL_TYPES_NAME = "PROTOCOL_TYPES";
    protected static final String ENCODE_FORMULA_NAME = "beforeEncode";
    protected static final String DECODE_FORMULA_NAME = "afterDecode";
    protected static final String JAVA_TYPES_NAME = "JAVA_TYPES";

    public static Type wrapperClass(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        switch (name) {
            case "boolean": {
                return Boolean.class;
            }
            case "byte": {
                return Byte.class;
            }
            case "char": {
                return Character.class;
            }
            case "short": {
                return Short.class;
            }
            case "int": {
                return Integer.class;
            }
            case "long": {
                return Long.class;
            }
            case "float": {
                return Float.class;
            }
            case "double": {
                return Double.class;
            }
        }
        throw new CodecException(MessageFormat.format(CodecError.UNSUPPORTED_TYPE.getMessage(), name));
    }

    public static int size(@NonNull ProtocolType type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return type.getTypeAnnotationClass().getDeclaredField(SIZE_NAME).getInt(null);
    }

    public static ProtocolType[] protocolTypes(@NonNull Annotation typeAnnotation) {
        if (typeAnnotation == null) {
            throw new NullPointerException("typeAnnotation is marked non-null but is null");
        }
        return (ProtocolType[])typeAnnotation.annotationType().getDeclaredField(PROTOCOL_TYPES_NAME).get(typeAnnotation);
    }

    public static Class<? extends Function> encodeFormula(@NonNull Annotation typeAnnotation) {
        if (typeAnnotation == null) {
            throw new NullPointerException("typeAnnotation is marked non-null but is null");
        }
        return TypeUtils.formula(typeAnnotation, ENCODE_FORMULA_NAME);
    }

    public static Class<? extends Function> decodeFormula(@NonNull Annotation typeAnnotation) {
        if (typeAnnotation == null) {
            throw new NullPointerException("typeAnnotation is marked non-null but is null");
        }
        return TypeUtils.formula(typeAnnotation, DECODE_FORMULA_NAME);
    }

    protected static Class<? extends Function> formula(@NonNull Annotation typeAnnotation, @NonNull String name) {
        if (typeAnnotation == null) {
            throw new NullPointerException("typeAnnotation is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        Method method = typeAnnotation.getClass().getMethod(name, new Class[0]);
        Object array = method.invoke((Object)typeAnnotation, new Object[0]);
        return Optional.of(array).filter(a -> a.getClass().isArray()).filter(a -> Array.getLength(a) >= 1).map(a -> Array.get(a, 0)).map(o -> (Class)o).orElse(null);
    }

    public static Type[] javaTypes(@NonNull Annotation typeAnnotation) {
        if (typeAnnotation == null) {
            throw new NullPointerException("typeAnnotation is marked non-null but is null");
        }
        return (Type[])typeAnnotation.annotationType().getDeclaredField(JAVA_TYPES_NAME).get(typeAnnotation);
    }

    public static Type[] javaTypes(@NonNull Class<? extends Annotation> typeAnnotationClass) {
        if (typeAnnotationClass == null) {
            throw new NullPointerException("typeAnnotationClass is marked non-null but is null");
        }
        return (Type[])typeAnnotationClass.getDeclaredField(JAVA_TYPES_NAME).get(null);
    }

    public static int byteOffset(@NonNull Annotation typeAnnotation) {
        if (typeAnnotation == null) {
            throw new NullPointerException("typeAnnotation is marked non-null but is null");
        }
        try {
            return (Integer)typeAnnotation.getClass().getMethod(BYTE_OFFSET_NAME, new Class[0]).invoke((Object)typeAnnotation, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return 0;
        }
    }

    public static int size(@NonNull Annotation typeAnnotation) {
        if (typeAnnotation == null) {
            throw new NullPointerException("typeAnnotation is marked non-null but is null");
        }
        try {
            return typeAnnotation.getClass().getField(SIZE_NAME).getInt(typeAnnotation);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return 0;
        }
    }

    public static int length(@NonNull Annotation typeAnnotation) {
        if (typeAnnotation == null) {
            throw new NullPointerException("typeAnnotation is marked non-null but is null");
        }
        try {
            return (Integer)typeAnnotation.getClass().getMethod(LENGTH_NAME, new Class[0]).invoke((Object)typeAnnotation, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return 0;
        }
    }
}

