/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto;

import lombok.NonNull;
import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.TypeAssist;
import org.indunet.fastproto.annotation.EnableProtocolVersion;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.exception.ProtocolVersionException;
import org.indunet.fastproto.util.DecodeUtils;
import org.indunet.fastproto.util.EncodeUtils;

public class ProtocolVersionAssist {
    public static boolean validate(@NonNull byte[] datagram, @NonNull TypeAssist assist) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (assist == null) {
            throw new NullPointerException("assist is marked non-null but is null");
        }
        if (assist.getEnableProtocolVersion() == null) {
            return true;
        }
        EnableProtocolVersion enableProtocolVersion = assist.getEnableProtocolVersion();
        return enableProtocolVersion.version() == ProtocolVersionAssist.decode(datagram, assist);
    }

    public static int decode(@NonNull byte[] datagram, @NonNull TypeAssist assist) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (assist == null) {
            throw new NullPointerException("assist is marked non-null but is null");
        }
        if (assist.getEnableProtocolVersion() == null) {
            return -1;
        }
        EnableProtocolVersion enableProtocolVersion = assist.getEnableProtocolVersion();
        EndianPolicy policy = ProtocolVersionAssist.endianPolicy(assist);
        int byteOffset = enableProtocolVersion.value();
        switch (enableProtocolVersion.protocolType()) {
            case UINTEGER8: {
                return DecodeUtils.uInteger8Type(datagram, byteOffset);
            }
            case UINTEGER16: {
                return DecodeUtils.uInteger16Type(datagram, byteOffset, policy);
            }
            case INTEGER: {
                return DecodeUtils.integerType(datagram, byteOffset, policy);
            }
        }
        throw new ProtocolVersionException(CodecError.ILLEGAL_PROTOCOL_VERSION_TYPE);
    }

    public static void encode(@NonNull byte[] datagram, @NonNull TypeAssist assist) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (assist == null) {
            throw new NullPointerException("assist is marked non-null but is null");
        }
        if (assist.getEnableProtocolVersion() == null) {
            return;
        }
        EnableProtocolVersion versionAnnotation = assist.getEnableProtocolVersion();
        EndianPolicy policy = ProtocolVersionAssist.endianPolicy(assist);
        int byteOffset = versionAnnotation.value();
        int version = versionAnnotation.version();
        switch (versionAnnotation.protocolType()) {
            case UINTEGER8: {
                EncodeUtils.uInteger8Type(datagram, byteOffset, version);
                break;
            }
            case UINTEGER16: {
                EncodeUtils.uInteger16Type(datagram, byteOffset, policy, version);
                break;
            }
            case INTEGER: {
                EncodeUtils.integerType(datagram, byteOffset, policy, version);
                break;
            }
            default: {
                throw new ProtocolVersionException(CodecError.ILLEGAL_PROTOCOL_VERSION_TYPE);
            }
        }
    }

    public static EndianPolicy endianPolicy(@NonNull TypeAssist assist) {
        if (assist == null) {
            throw new NullPointerException("assist is marked non-null but is null");
        }
        EnableProtocolVersion enableProtocolVersion = assist.getEnableProtocolVersion();
        if (enableProtocolVersion.endianPolicy().length > 0) {
            return enableProtocolVersion.endianPolicy()[0];
        }
        return assist.getEndianPolicy();
    }

    public static int size(@NonNull TypeAssist assist) {
        if (assist == null) {
            throw new NullPointerException("assist is marked non-null but is null");
        }
        if (assist.getEnableProtocolVersion() == null) {
            return 0;
        }
        EnableProtocolVersion enableProtocolVersion = assist.getEnableProtocolVersion();
        switch (enableProtocolVersion.protocolType()) {
            case UINTEGER8: {
                return 1;
            }
            case UINTEGER16: {
                return 2;
            }
            case INTEGER: {
                return 4;
            }
        }
        throw new ProtocolVersionException(CodecError.ILLEGAL_PROTOCOL_VERSION_TYPE);
    }
}

