/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.indunet.fastproto.CodecFeature;
import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.ProtocolType;
import org.indunet.fastproto.annotation.DecodeIgnore;
import org.indunet.fastproto.annotation.Decoder;
import org.indunet.fastproto.annotation.EnableChecksum;
import org.indunet.fastproto.annotation.EnableCompress;
import org.indunet.fastproto.annotation.EnableCrypto;
import org.indunet.fastproto.annotation.EnableFixedLength;
import org.indunet.fastproto.annotation.EnableProtocolVersion;
import org.indunet.fastproto.annotation.EncodeIgnore;
import org.indunet.fastproto.annotation.Encoder;
import org.indunet.fastproto.annotation.Endian;
import org.indunet.fastproto.annotation.TypeFlag;
import org.indunet.fastproto.annotation.type.AutoType;
import org.indunet.fastproto.decoder.DecodeContext;
import org.indunet.fastproto.decoder.TypeDecoder;
import org.indunet.fastproto.encoder.EncodeContext;
import org.indunet.fastproto.encoder.TypeEncoder;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.exception.CodecException;
import org.indunet.fastproto.exception.CryptoException;
import org.indunet.fastproto.exception.DecodeException;
import org.indunet.fastproto.exception.DecodeFormulaException;
import org.indunet.fastproto.exception.EncodeException;
import org.indunet.fastproto.pipeline.AbstractFlow;
import org.indunet.fastproto.pipeline.ValidationContext;
import org.indunet.fastproto.util.TypeUtils;

public class TypeAssist {
    protected static ConcurrentHashMap<Class<?>, TypeAssist> typeAssists = new ConcurrentHashMap();
    protected static final ThreadLocal<Object> instance = new ThreadLocal();
    protected static final ThreadLocal<Map<Class<?>, Object>> objects = new ThreadLocal();
    protected static final ThreadLocal<Set<Class<?>>> protocolClasses = new ThreadLocal();
    TypeAssist parent;
    Class<?> clazz;
    Field field;
    Annotation typeAnnotation;
    EndianPolicy endianPolicy;
    Boolean decodeIgnore;
    Boolean encodeIgnore;
    ElementType elementType;
    List<TypeAssist> elements;
    Class<? extends TypeDecoder> decoderClass;
    Class<? extends TypeEncoder> encoderClass;
    Class<? extends Function> decodeFormula;
    Class<? extends Function> encodeFormula;
    Function<DecodeContext, ?> decoder;
    Consumer<?> encoder;
    Integer fixedLength;
    EnableCrypto enableCrypto;
    byte[] key;
    EnableCompress enableCompress;
    EnableProtocolVersion enableProtocolVersion;
    EnableChecksum enableChecksum;
    Boolean circularReference = false;
    Integer byteOffset;
    Integer bitOffset;
    Integer size;
    Integer length;
    long codecFeature;
    Boolean noArgsConstructor;

    protected TypeAssist() {
    }

    public static TypeAssist byClass(Class<?> protocolClass) {
        return typeAssists.computeIfAbsent(protocolClass, c -> TypeAssist.get(c));
    }

    public static TypeAssist get(@NonNull Class<?> protocolClass) {
        if (protocolClass == null) {
            throw new NullPointerException("protocolClass is marked non-null but is null");
        }
        protocolClasses.set(new HashSet());
        TypeAssist assist = TypeAssist.resolveClass(protocolClass);
        EnableCrypto enableCrypto = Optional.of(protocolClass).map(c -> c.getAnnotation(EnableCrypto.class)).orElse(null);
        assist.setEnableCrypto(enableCrypto);
        if (enableCrypto != null) {
            if (!enableCrypto.key().isEmpty()) {
                assist.setKey(enableCrypto.key().getBytes());
            } else if (enableCrypto.keySupplier().length != 0) {
                assist.setKey(Optional.of(enableCrypto).map(EnableCrypto::keySupplier).map(a -> {
                    try {
                        Class c = a[0];
                        return (byte[])((Supplier)c.newInstance()).get();
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        throw new CryptoException(CodecError.INVALID_CRYPTO_KEY_SUPPLIER, (Throwable)e);
                    }
                }).get());
            } else {
                throw new CryptoException(CodecError.NO_CRYPTO_KEY);
            }
        }
        assist.setEnableCompress(Optional.of(protocolClass).map(c -> c.getAnnotation(EnableCompress.class)).orElse(null));
        assist.setEnableProtocolVersion(Optional.of(protocolClass).map(c -> c.getAnnotation(EnableProtocolVersion.class)).orElse(null));
        assist.setEnableChecksum(Optional.of(protocolClass).map(c -> c.getAnnotation(EnableChecksum.class)).orElse(null));
        assist.setFixedLength(Optional.of(protocolClass).map(c -> c.getAnnotation(EnableFixedLength.class)).map(EnableFixedLength::value).orElse(null));
        assist.setCodecFeature(CodecFeature.of(assist));
        protocolClasses.remove();
        return assist;
    }

    protected static TypeAssist resolveClass(@NonNull Class<?> protocolClass) {
        if (protocolClass == null) {
            throw new NullPointerException("protocolClass is marked non-null but is null");
        }
        protocolClasses.get().add(protocolClass);
        boolean noArgsConstructor = Arrays.stream(protocolClass.getConstructors()).anyMatch(c -> c.getParameterCount() == 0);
        Predicate<Field> isType = f -> Arrays.stream(f.getAnnotations()).map(Annotation::annotationType).anyMatch(t -> t.isAnnotationPresent(TypeFlag.class));
        Stream<TypeAssist> typeStream = Arrays.stream(protocolClass.getDeclaredFields()).filter(f -> !f.isAnnotationPresent(DecodeIgnore.class) && !f.isAnnotationPresent(EncodeIgnore.class)).filter(isType.negate()).filter(f -> !f.getType().isEnum()).filter(f -> !Modifier.isTransient(f.getModifiers())).filter(f -> !f.getType().isArray()).filter(f -> f.getType() instanceof Class).filter(f -> Arrays.stream(ProtocolType.supportedTypes()).noneMatch(t -> t == f.getType())).map(f -> {
            f.setAccessible(true);
            Class<?> c = f.getType();
            if (protocolClasses.get().contains(c)) {
                Boolean decodeIgnore = f.isAnnotationPresent(DecodeIgnore.class);
                return TypeAssist.builder().clazz(c).field((Field)f).typeAnnotation(null).decoderClass(null).encoderClass(null).decodeFormula(null).encodeFormula(null).endianPolicy(EndianPolicy.LITTLE).decodeIgnore(decodeIgnore).encodeIgnore(true).elementType(ElementType.TYPE).circularReference(true).elements(new ArrayList<TypeAssist>()).build();
            }
            TypeAssist a = TypeAssist.resolveClass(c);
            Boolean decodeIgnore = f.isAnnotationPresent(DecodeIgnore.class);
            Boolean encodeIgnore = f.isAnnotationPresent(EncodeIgnore.class);
            a.setDecodeIgnore(decodeIgnore);
            a.setEncodeIgnore(encodeIgnore);
            a.setField((Field)f);
            a.setCircularReference(false);
            return a;
        }).filter(a -> a.hasElement() || a.getCircularReference() != false);
        EndianPolicy endianPolicy = Optional.ofNullable(protocolClass.getAnnotation(Endian.class)).map(Endian::value).orElse(EndianPolicy.LITTLE);
        Boolean decodeIgnore = protocolClass.isAnnotationPresent(DecodeIgnore.class);
        Boolean encodeIgnore = protocolClass.isAnnotationPresent(EncodeIgnore.class);
        Stream<TypeAssist> fieldStream = Arrays.stream(protocolClass.getDeclaredFields()).filter(f -> !f.isAnnotationPresent(DecodeIgnore.class) && !f.isAnnotationPresent(EncodeIgnore.class)).filter(isType).peek(f -> f.setAccessible(true)).map(TypeAssist::resolveField).peek(a -> {
            if (a.getEndianPolicy() == null) {
                a.setEndianPolicy(endianPolicy);
            }
        });
        TypeAssist assist = TypeAssist.builder().clazz(protocolClass).field(null).typeAnnotation(null).decoderClass(null).encoderClass(null).decodeFormula(null).encodeFormula(null).endianPolicy(endianPolicy).decodeIgnore(decodeIgnore).encodeIgnore(encodeIgnore).elementType(ElementType.TYPE).circularReference(false).noArgsConstructor(noArgsConstructor).build();
        List<TypeAssist> elements = Stream.concat(fieldStream, typeStream).peek(a -> a.setParent(assist)).collect(Collectors.toList());
        assist.setElements(elements);
        return assist;
    }

    protected static TypeAssist resolveField(Field field) {
        EndianPolicy policy = Optional.ofNullable(field.getAnnotation(Endian.class)).map(Endian::value).orElse(null);
        Boolean decodeIgnore = field.isAnnotationPresent(DecodeIgnore.class);
        Boolean encodeIgnore = field.isAnnotationPresent(EncodeIgnore.class);
        Class<? extends Annotation> typeAnnotationClass = TypeAssist.getTypeAnnotationClass(field);
        Annotation typeAnnotation = TypeAssist.getTypeAnnotation(field);
        Class decoder = Optional.of(typeAnnotationClass).map(t -> t.getAnnotation(Decoder.class)).map(Decoder::value).orElse(null);
        Class encoder = Optional.of(typeAnnotationClass).map(t -> t.getAnnotation(Encoder.class)).map(Encoder::value).orElse(null);
        Function<String, Class> formula = name -> {
            try {
                Method method = typeAnnotation.getClass().getMethod((String)name, new Class[0]);
                Object array = method.invoke((Object)typeAnnotation, new Object[0]);
                return Optional.of(array).filter(a -> a.getClass().isArray()).filter(a -> Array.getLength(a) >= 1).map(a -> Array.get(a, 0)).map(o -> (Class)o).orElse(null);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
                throw new DecodeFormulaException(MessageFormat.format(CodecError.FAIL_GETTING_DECODE_FORMULA.getMessage(), typeAnnotation.annotationType().getName(), field.getName()), (Throwable)e);
            }
        };
        Class afterDecode = formula.apply("afterDecode");
        Class beforeEncode = formula.apply("beforeEncode");
        ValidationContext context = ValidationContext.builder().field(field).typeAnnotation(TypeAssist.getProxyTypeAnnotation(field)).build();
        AbstractFlow.getValidateFlow().process(context);
        Annotation proxyTypeAnnotation = TypeAssist.getProxyTypeAnnotation(field);
        return TypeAssist.builder().clazz(field.getType()).field(field).typeAnnotation(proxyTypeAnnotation).decoderClass(decoder).encoderClass(encoder).decodeFormula(afterDecode).encodeFormula(beforeEncode).endianPolicy(policy).decodeIgnore(decodeIgnore).encodeIgnore(encodeIgnore).elementType(ElementType.FIELD).circularReference(false).byteOffset(TypeUtils.byteOffset(proxyTypeAnnotation)).bitOffset(TypeUtils.bitOffset(proxyTypeAnnotation)).length(TypeUtils.length(proxyTypeAnnotation)).size(TypeUtils.size(proxyTypeAnnotation)).build();
    }

    protected static Class<? extends Annotation> getTypeAnnotationClass(@NonNull Field field) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        Annotation typeAnnotation = TypeAssist.getTypeAnnotation(field);
        if (typeAnnotation instanceof AutoType) {
            return ProtocolType.byAutoType(field.getType()).typeAnnotationClass;
        }
        return typeAnnotation.annotationType();
    }

    protected static Annotation getTypeAnnotation(@NonNull Field field) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        return Arrays.stream(field.getAnnotations()).filter(a -> a.annotationType().isAnnotationPresent(TypeFlag.class)).findAny().orElseThrow(CodecException::new);
    }

    protected static Annotation getProxyTypeAnnotation(@NonNull Field field) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        Annotation typeAnnotation = TypeAssist.getTypeAnnotation(field);
        if (typeAnnotation instanceof AutoType) {
            Class<? extends Annotation> typeAnnotationClass = ProtocolType.byAutoType(field.getType()).typeAnnotationClass;
            return typeAnnotationClass.cast(Proxy.newProxyInstance(ClassLoader.getSystemClassLoader(), new Class[]{typeAnnotationClass}, (object, method, parameters) -> Arrays.stream(typeAnnotation.annotationType().getMethods()).filter(m -> m.getName().equals(method.getName())).findAny().orElseThrow(CodecException::new).invoke((Object)typeAnnotation, new Object[0])));
        }
        return typeAnnotation;
    }

    public <T> T getObject(Class<T> clazz) {
        Object object = instance.get();
        instance.remove();
        return (T)object;
    }

    public boolean hasElement() {
        return this.elements != null && !this.elements.isEmpty();
    }

    public void setValue(Object object, Object value) {
        try {
            this.field.set(object, value);
        }
        catch (IllegalAccessException e) {
            throw new DecodeException(MessageFormat.format(CodecError.FAIL_ASSIGN_VALUE.getMessage(), this.field.getName()), (Throwable)e);
        }
    }

    public DecodeContext toDecodeContext(byte[] datagram, Object object) {
        return DecodeContext.builder().object(object).datagram(datagram).typeAssist(this).build();
    }

    protected List<DecodeContext> toDecodeContexts(byte[] datagram, Object parent) {
        try {
            Object value;
            if (objects.get().containsKey(this.clazz)) {
                value = objects.get().get(this.clazz);
            } else {
                value = this.clazz.newInstance();
                objects.get().put(this.clazz, value);
            }
            if (parent == null) {
                instance.set(value);
            }
            if (parent != null && this.field != null) {
                try {
                    this.field.set(parent, value);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            Stream<DecodeContext> fieldStream = this.elements.stream().filter(a -> a.getElementType() == ElementType.FIELD).map(a -> a.toDecodeContext(datagram, value));
            Stream classStream = this.elements.stream().filter(a -> a.getElementType() == ElementType.TYPE).flatMap(a -> a.toDecodeContexts(datagram, value).stream());
            return Stream.concat(fieldStream, classStream).collect(Collectors.toList());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new DecodeException(MessageFormat.format(CodecError.FAIL_INITIALIZING_DECODE_OBJECT.getMessage(), this.clazz.getName()), (Throwable)e);
        }
    }

    public List<DecodeContext> toDecodeContexts(byte[] datagram) {
        objects.set(new HashMap());
        List<DecodeContext> contexts = this.toDecodeContexts(datagram, null);
        objects.remove();
        return contexts;
    }

    public EncodeContext toEncodeContext(Object object, byte[] datagram) {
        try {
            return EncodeContext.builder().datagram(datagram).typeAssist(this).value(this.field.get(object)).build();
        }
        catch (IllegalAccessException e) {
            throw new EncodeException(MessageFormat.format(CodecError.FAIL_GETTING_FIELD_VALUE.getMessage(), this.field.getName()), (Throwable)e);
        }
    }

    public List<EncodeContext> toEncodeContexts(Object object, byte[] datagram) {
        Stream<EncodeContext> fieldStream = this.elements.stream().filter(a -> a.getElementType() == ElementType.FIELD).map(a -> a.toEncodeContext(object, datagram));
        Stream classStream = this.elements.stream().filter(a -> a.getElementType() == ElementType.TYPE).flatMap(a -> {
            try {
                if (object != null && a.field.get(object) != null) {
                    return a.toEncodeContexts(a.field.get(object), datagram).stream();
                }
                return Stream.empty();
            }
            catch (IllegalAccessException e) {
                throw new DecodeException(MessageFormat.format(CodecError.FAIL_GETTING_FIELD_VALUE.getMessage(), this.clazz.getName()), (Throwable)e);
            }
        });
        return Stream.concat(fieldStream, classStream).filter(c -> c.getValue() != null).collect(Collectors.toList());
    }

    public static TypeAssistBuilder builder() {
        return new TypeAssistBuilder();
    }

    public TypeAssist getParent() {
        return this.parent;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public Field getField() {
        return this.field;
    }

    public Annotation getTypeAnnotation() {
        return this.typeAnnotation;
    }

    public EndianPolicy getEndianPolicy() {
        return this.endianPolicy;
    }

    public Boolean getDecodeIgnore() {
        return this.decodeIgnore;
    }

    public Boolean getEncodeIgnore() {
        return this.encodeIgnore;
    }

    public ElementType getElementType() {
        return this.elementType;
    }

    public List<TypeAssist> getElements() {
        return this.elements;
    }

    public Class<? extends TypeDecoder> getDecoderClass() {
        return this.decoderClass;
    }

    public Class<? extends TypeEncoder> getEncoderClass() {
        return this.encoderClass;
    }

    public Class<? extends Function> getDecodeFormula() {
        return this.decodeFormula;
    }

    public Class<? extends Function> getEncodeFormula() {
        return this.encodeFormula;
    }

    public Function<DecodeContext, ?> getDecoder() {
        return this.decoder;
    }

    public Consumer<?> getEncoder() {
        return this.encoder;
    }

    public Integer getFixedLength() {
        return this.fixedLength;
    }

    public EnableCrypto getEnableCrypto() {
        return this.enableCrypto;
    }

    public byte[] getKey() {
        return this.key;
    }

    public EnableCompress getEnableCompress() {
        return this.enableCompress;
    }

    public EnableProtocolVersion getEnableProtocolVersion() {
        return this.enableProtocolVersion;
    }

    public EnableChecksum getEnableChecksum() {
        return this.enableChecksum;
    }

    public Boolean getCircularReference() {
        return this.circularReference;
    }

    public Integer getByteOffset() {
        return this.byteOffset;
    }

    public Integer getBitOffset() {
        return this.bitOffset;
    }

    public Integer getSize() {
        return this.size;
    }

    public Integer getLength() {
        return this.length;
    }

    public long getCodecFeature() {
        return this.codecFeature;
    }

    public Boolean getNoArgsConstructor() {
        return this.noArgsConstructor;
    }

    public void setParent(TypeAssist parent) {
        this.parent = parent;
    }

    public void setClazz(Class<?> clazz) {
        this.clazz = clazz;
    }

    public void setField(Field field) {
        this.field = field;
    }

    public void setTypeAnnotation(Annotation typeAnnotation) {
        this.typeAnnotation = typeAnnotation;
    }

    public void setEndianPolicy(EndianPolicy endianPolicy) {
        this.endianPolicy = endianPolicy;
    }

    public void setDecodeIgnore(Boolean decodeIgnore) {
        this.decodeIgnore = decodeIgnore;
    }

    public void setEncodeIgnore(Boolean encodeIgnore) {
        this.encodeIgnore = encodeIgnore;
    }

    public void setElementType(ElementType elementType) {
        this.elementType = elementType;
    }

    public void setElements(List<TypeAssist> elements) {
        this.elements = elements;
    }

    public void setDecoderClass(Class<? extends TypeDecoder> decoderClass) {
        this.decoderClass = decoderClass;
    }

    public void setEncoderClass(Class<? extends TypeEncoder> encoderClass) {
        this.encoderClass = encoderClass;
    }

    public void setDecodeFormula(Class<? extends Function> decodeFormula) {
        this.decodeFormula = decodeFormula;
    }

    public void setEncodeFormula(Class<? extends Function> encodeFormula) {
        this.encodeFormula = encodeFormula;
    }

    public void setDecoder(Function<DecodeContext, ?> decoder) {
        this.decoder = decoder;
    }

    public void setEncoder(Consumer<?> encoder) {
        this.encoder = encoder;
    }

    public void setFixedLength(Integer fixedLength) {
        this.fixedLength = fixedLength;
    }

    public void setEnableCrypto(EnableCrypto enableCrypto) {
        this.enableCrypto = enableCrypto;
    }

    public void setKey(byte[] key) {
        this.key = key;
    }

    public void setEnableCompress(EnableCompress enableCompress) {
        this.enableCompress = enableCompress;
    }

    public void setEnableProtocolVersion(EnableProtocolVersion enableProtocolVersion) {
        this.enableProtocolVersion = enableProtocolVersion;
    }

    public void setEnableChecksum(EnableChecksum enableChecksum) {
        this.enableChecksum = enableChecksum;
    }

    public void setCircularReference(Boolean circularReference) {
        this.circularReference = circularReference;
    }

    public void setByteOffset(Integer byteOffset) {
        this.byteOffset = byteOffset;
    }

    public void setBitOffset(Integer bitOffset) {
        this.bitOffset = bitOffset;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public void setLength(Integer length) {
        this.length = length;
    }

    public void setCodecFeature(long codecFeature) {
        this.codecFeature = codecFeature;
    }

    public void setNoArgsConstructor(Boolean noArgsConstructor) {
        this.noArgsConstructor = noArgsConstructor;
    }

    public TypeAssist(TypeAssist parent, Class<?> clazz, Field field, Annotation typeAnnotation, EndianPolicy endianPolicy, Boolean decodeIgnore, Boolean encodeIgnore, ElementType elementType, List<TypeAssist> elements, Class<? extends TypeDecoder> decoderClass, Class<? extends TypeEncoder> encoderClass, Class<? extends Function> decodeFormula, Class<? extends Function> encodeFormula, Function<DecodeContext, ?> decoder, Consumer<?> encoder, Integer fixedLength, EnableCrypto enableCrypto, byte[] key, EnableCompress enableCompress, EnableProtocolVersion enableProtocolVersion, EnableChecksum enableChecksum, Boolean circularReference, Integer byteOffset, Integer bitOffset, Integer size, Integer length, long codecFeature, Boolean noArgsConstructor) {
        this.parent = parent;
        this.clazz = clazz;
        this.field = field;
        this.typeAnnotation = typeAnnotation;
        this.endianPolicy = endianPolicy;
        this.decodeIgnore = decodeIgnore;
        this.encodeIgnore = encodeIgnore;
        this.elementType = elementType;
        this.elements = elements;
        this.decoderClass = decoderClass;
        this.encoderClass = encoderClass;
        this.decodeFormula = decodeFormula;
        this.encodeFormula = encodeFormula;
        this.decoder = decoder;
        this.encoder = encoder;
        this.fixedLength = fixedLength;
        this.enableCrypto = enableCrypto;
        this.key = key;
        this.enableCompress = enableCompress;
        this.enableProtocolVersion = enableProtocolVersion;
        this.enableChecksum = enableChecksum;
        this.circularReference = circularReference;
        this.byteOffset = byteOffset;
        this.bitOffset = bitOffset;
        this.size = size;
        this.length = length;
        this.codecFeature = codecFeature;
        this.noArgsConstructor = noArgsConstructor;
    }

    public static class TypeAssistBuilder {
        private TypeAssist parent;
        private Class<?> clazz;
        private Field field;
        private Annotation typeAnnotation;
        private EndianPolicy endianPolicy;
        private Boolean decodeIgnore;
        private Boolean encodeIgnore;
        private ElementType elementType;
        private List<TypeAssist> elements;
        private Class<? extends TypeDecoder> decoderClass;
        private Class<? extends TypeEncoder> encoderClass;
        private Class<? extends Function> decodeFormula;
        private Class<? extends Function> encodeFormula;
        private Function<DecodeContext, ?> decoder;
        private Consumer<?> encoder;
        private Integer fixedLength;
        private EnableCrypto enableCrypto;
        private byte[] key;
        private EnableCompress enableCompress;
        private EnableProtocolVersion enableProtocolVersion;
        private EnableChecksum enableChecksum;
        private Boolean circularReference;
        private Integer byteOffset;
        private Integer bitOffset;
        private Integer size;
        private Integer length;
        private long codecFeature;
        private Boolean noArgsConstructor;

        TypeAssistBuilder() {
        }

        public TypeAssistBuilder parent(TypeAssist parent) {
            this.parent = parent;
            return this;
        }

        public TypeAssistBuilder clazz(Class<?> clazz) {
            this.clazz = clazz;
            return this;
        }

        public TypeAssistBuilder field(Field field) {
            this.field = field;
            return this;
        }

        public TypeAssistBuilder typeAnnotation(Annotation typeAnnotation) {
            this.typeAnnotation = typeAnnotation;
            return this;
        }

        public TypeAssistBuilder endianPolicy(EndianPolicy endianPolicy) {
            this.endianPolicy = endianPolicy;
            return this;
        }

        public TypeAssistBuilder decodeIgnore(Boolean decodeIgnore) {
            this.decodeIgnore = decodeIgnore;
            return this;
        }

        public TypeAssistBuilder encodeIgnore(Boolean encodeIgnore) {
            this.encodeIgnore = encodeIgnore;
            return this;
        }

        public TypeAssistBuilder elementType(ElementType elementType) {
            this.elementType = elementType;
            return this;
        }

        public TypeAssistBuilder elements(List<TypeAssist> elements) {
            this.elements = elements;
            return this;
        }

        public TypeAssistBuilder decoderClass(Class<? extends TypeDecoder> decoderClass) {
            this.decoderClass = decoderClass;
            return this;
        }

        public TypeAssistBuilder encoderClass(Class<? extends TypeEncoder> encoderClass) {
            this.encoderClass = encoderClass;
            return this;
        }

        public TypeAssistBuilder decodeFormula(Class<? extends Function> decodeFormula) {
            this.decodeFormula = decodeFormula;
            return this;
        }

        public TypeAssistBuilder encodeFormula(Class<? extends Function> encodeFormula) {
            this.encodeFormula = encodeFormula;
            return this;
        }

        public TypeAssistBuilder decoder(Function<DecodeContext, ?> decoder) {
            this.decoder = decoder;
            return this;
        }

        public TypeAssistBuilder encoder(Consumer<?> encoder) {
            this.encoder = encoder;
            return this;
        }

        public TypeAssistBuilder fixedLength(Integer fixedLength) {
            this.fixedLength = fixedLength;
            return this;
        }

        public TypeAssistBuilder enableCrypto(EnableCrypto enableCrypto) {
            this.enableCrypto = enableCrypto;
            return this;
        }

        public TypeAssistBuilder key(byte[] key) {
            this.key = key;
            return this;
        }

        public TypeAssistBuilder enableCompress(EnableCompress enableCompress) {
            this.enableCompress = enableCompress;
            return this;
        }

        public TypeAssistBuilder enableProtocolVersion(EnableProtocolVersion enableProtocolVersion) {
            this.enableProtocolVersion = enableProtocolVersion;
            return this;
        }

        public TypeAssistBuilder enableChecksum(EnableChecksum enableChecksum) {
            this.enableChecksum = enableChecksum;
            return this;
        }

        public TypeAssistBuilder circularReference(Boolean circularReference) {
            this.circularReference = circularReference;
            return this;
        }

        public TypeAssistBuilder byteOffset(Integer byteOffset) {
            this.byteOffset = byteOffset;
            return this;
        }

        public TypeAssistBuilder bitOffset(Integer bitOffset) {
            this.bitOffset = bitOffset;
            return this;
        }

        public TypeAssistBuilder size(Integer size) {
            this.size = size;
            return this;
        }

        public TypeAssistBuilder length(Integer length) {
            this.length = length;
            return this;
        }

        public TypeAssistBuilder codecFeature(long codecFeature) {
            this.codecFeature = codecFeature;
            return this;
        }

        public TypeAssistBuilder noArgsConstructor(Boolean noArgsConstructor) {
            this.noArgsConstructor = noArgsConstructor;
            return this;
        }

        public TypeAssist build() {
            return new TypeAssist(this.parent, this.clazz, this.field, this.typeAnnotation, this.endianPolicy, this.decodeIgnore, this.encodeIgnore, this.elementType, this.elements, this.decoderClass, this.encoderClass, this.decodeFormula, this.encodeFormula, this.decoder, this.encoder, this.fixedLength, this.enableCrypto, this.key, this.enableCompress, this.enableProtocolVersion, this.enableChecksum, this.circularReference, this.byteOffset, this.bitOffset, this.size, this.length, this.codecFeature, this.noArgsConstructor);
        }

        public String toString() {
            return "TypeAssist.TypeAssistBuilder(parent=" + this.parent + ", clazz=" + this.clazz + ", field=" + this.field + ", typeAnnotation=" + this.typeAnnotation + ", endianPolicy=" + (Object)((Object)this.endianPolicy) + ", decodeIgnore=" + this.decodeIgnore + ", encodeIgnore=" + this.encodeIgnore + ", elementType=" + (Object)((Object)this.elementType) + ", elements=" + this.elements + ", decoderClass=" + this.decoderClass + ", encoderClass=" + this.encoderClass + ", decodeFormula=" + this.decodeFormula + ", encodeFormula=" + this.encodeFormula + ", decoder=" + this.decoder + ", encoder=" + this.encoder + ", fixedLength=" + this.fixedLength + ", enableCrypto=" + this.enableCrypto + ", key=" + Arrays.toString(this.key) + ", enableCompress=" + this.enableCompress + ", enableProtocolVersion=" + this.enableProtocolVersion + ", enableChecksum=" + this.enableChecksum + ", circularReference=" + this.circularReference + ", byteOffset=" + this.byteOffset + ", bitOffset=" + this.bitOffset + ", size=" + this.size + ", length=" + this.length + ", codecFeature=" + this.codecFeature + ", noArgsConstructor=" + this.noArgsConstructor + ")";
        }
    }
}

