/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.checksum;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.annotation.EnableChecksum;
import org.indunet.fastproto.annotation.Endian;
import org.indunet.fastproto.checksum.Checker;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.exception.DecodeException;
import org.indunet.fastproto.exception.OutOfBoundsException;
import org.indunet.fastproto.util.DecodeUtils;
import org.indunet.fastproto.util.EncodeUtils;
import org.indunet.fastproto.util.ReverseUtils;

public class Crc16Checker
implements Checker {
    protected static final int defaultPoly = 40961;
    protected static final Map<Integer, Crc16Checker> checkers = new ConcurrentHashMap<Integer, Crc16Checker>();
    protected int poly;

    protected Crc16Checker(int poly) {
        this.poly = poly;
    }

    public static Crc16Checker getInstance() {
        return checkers.computeIfAbsent(40961, p -> new Crc16Checker((int)p));
    }

    public static synchronized Crc16Checker getInstance(int poly) {
        if (poly == 0) {
            return Crc16Checker.getInstance();
        }
        return checkers.computeIfAbsent(poly, p -> new Crc16Checker((int)p));
    }

    @Override
    public boolean validate(byte[] datagram, Class<?> protocolClass) {
        if (!protocolClass.isAnnotationPresent(EnableChecksum.class)) {
            return true;
        }
        EnableChecksum checkSum = protocolClass.getAnnotation(EnableChecksum.class);
        int byteOffset = checkSum.value();
        int start = checkSum.start();
        int length = checkSum.length();
        EndianPolicy policy = checkSum.endianPolicy().length != 0 ? checkSum.endianPolicy()[0] : (protocolClass.isAnnotationPresent(Endian.class) ? protocolClass.getAnnotation(Endian.class).value() : EndianPolicy.LITTLE);
        int actual = this.getValue(datagram, start, length);
        int expected = DecodeUtils.uInteger16Type(datagram, byteOffset, policy);
        return actual == expected;
    }

    @Override
    public void setValue(byte[] datagram, Class<?> protocolClass) {
        if (!protocolClass.isAnnotationPresent(EnableChecksum.class)) {
            return;
        }
        EnableChecksum checkSum = protocolClass.getAnnotation(EnableChecksum.class);
        int byteOffset = checkSum.value();
        int start = checkSum.start();
        int length = checkSum.length();
        EndianPolicy policy = checkSum.endianPolicy().length != 0 ? checkSum.endianPolicy()[0] : (protocolClass.isAnnotationPresent(Endian.class) ? protocolClass.getAnnotation(Endian.class).value() : EndianPolicy.LITTLE);
        this.setValue(datagram, byteOffset, start, length, policy);
    }

    @Override
    public int getSize() {
        return 2;
    }

    public int getValue(byte[] datagram, int start, int length) {
        int s = ReverseUtils.byteOffset(datagram.length, start);
        int l = ReverseUtils.length(datagram.length, start, length);
        if (s < 0) {
            throw new DecodeException(CodecError.ILLEGAL_BYTE_OFFSET);
        }
        if (l <= 0) {
            throw new DecodeException(CodecError.ILLEGAL_PARAMETER);
        }
        if (s + length > datagram.length) {
            throw new OutOfBoundsException(CodecError.EXCEEDED_DATAGRAM_SIZE);
        }
        int crc16 = 65535;
        for (int i = 0; i < l; ++i) {
            crc16 ^= datagram[s + i] & 0xFF;
            for (int j = 0; j < 8; ++j) {
                if ((crc16 & 1) == 1) {
                    crc16 >>>= 1;
                    crc16 ^= this.poly;
                    continue;
                }
                crc16 >>>= 1;
            }
        }
        return crc16;
    }

    public void setValue(byte[] datagram, int byteOffset, int start, int length, EndianPolicy policy) {
        int value = this.getValue(datagram, start, length);
        EncodeUtils.uInteger16Type(datagram, byteOffset, policy, value);
    }
}

