/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.decoder;

import java.text.MessageFormat;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.indunet.fastproto.decoder.DecodeContext;
import org.indunet.fastproto.decoder.TypeDecoder;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.exception.DecodeException;

public class DecoderFactory {
    protected static ConcurrentHashMap<Class<? extends TypeDecoder>, TypeDecoder<?>> decoders = new ConcurrentHashMap();
    protected static ConcurrentHashMap<Class<? extends Function>, Function> formulas = new ConcurrentHashMap();

    public static Function<DecodeContext, ?> getDecoder(Class<? extends TypeDecoder> clazz) {
        return decoders.computeIfAbsent(clazz, c -> {
            try {
                return (TypeDecoder)c.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
                throw new DecodeException(MessageFormat.format(CodecError.FAIL_INITIALIZING_DECODER.getMessage(), clazz.getName()), (Throwable)e);
            }
        })::decode;
    }

    public static <T, R> Function<T, R> getFormula(Class<? extends Function> clazz) {
        return formulas.computeIfAbsent(clazz, c -> {
            try {
                return (Function)c.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
                throw new DecodeException(MessageFormat.format(CodecError.FAIL_INITIALIZING_DECODE_FORMULA.getMessage(), clazz.getName()), (Throwable)e);
            }
        });
    }

    public static Function<DecodeContext, ?> getDecoder(Class<? extends TypeDecoder> decoderClass, Class<? extends Function> formulaClass) {
        if (formulaClass != null) {
            return DecoderFactory.getDecoder(decoderClass).andThen(DecoderFactory.getFormula(formulaClass));
        }
        return DecoderFactory.getDecoder(decoderClass);
    }
}

