/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.decoder;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.IntStream;
import lombok.NonNull;
import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.ProtocolType;
import org.indunet.fastproto.annotation.type.ArrayType;
import org.indunet.fastproto.decoder.DecodeContext;
import org.indunet.fastproto.decoder.TypeDecoder;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.exception.DecodeException;
import org.indunet.fastproto.exception.OutOfBoundsException;
import org.indunet.fastproto.util.DecodeUtils;
import org.indunet.fastproto.util.ReverseUtils;
import org.indunet.fastproto.util.TypeUtils;

public class ListDecoder
implements TypeDecoder<List<?>> {
    @Override
    public List<?> decode(DecodeContext context) {
        ArrayType type = context.getTypeAnnotation(ArrayType.class);
        return this.decode(context.getDatagram(), type.value(), type.length(), type.protocolType(), context.getEndianPolicy());
    }

    public List decode(@NonNull byte[] datagram, int byteOffset, int length, @NonNull ProtocolType type, @NonNull EndianPolicy policy) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (policy == null) {
            throw new NullPointerException("policy is marked non-null but is null");
        }
        int size = TypeUtils.size(type);
        int bo = ReverseUtils.byteOffset(datagram.length, byteOffset);
        if (bo < 0) {
            throw new DecodeException(CodecError.ILLEGAL_BYTE_OFFSET);
        }
        if (bo >= datagram.length) {
            throw new DecodeException(CodecError.ILLEGAL_BYTE_OFFSET);
        }
        if (length <= 0) {
            throw new DecodeException(CodecError.ILLEGAL_PARAMETER);
        }
        if (bo + size * length > datagram.length) {
            throw new OutOfBoundsException(CodecError.EXCEEDED_DATAGRAM_SIZE);
        }
        BiFunction<Function, List, List> codec = (func, list) -> {
            IntStream.range(0, length).parallel().forEachOrdered(i -> list.add(func.apply(i * size + bo)));
            return list;
        };
        switch (type) {
            case CHARACTER: {
                return codec.apply(b -> Character.valueOf(DecodeUtils.characterType(datagram, b, policy)), new ArrayList());
            }
            case BYTE: {
                return codec.apply(b -> DecodeUtils.byteType(datagram, b), new ArrayList());
            }
            case SHORT: {
                return codec.apply(b -> DecodeUtils.shortType(datagram, b, policy), new ArrayList());
            }
            case INTEGER: {
                return codec.apply(b -> DecodeUtils.integerType(datagram, b, policy), new ArrayList());
            }
            case LONG: {
                return codec.apply(b -> DecodeUtils.longType(datagram, b, policy), new ArrayList());
            }
            case UINTEGER8: {
                return codec.apply(b -> DecodeUtils.uInteger8Type(datagram, b), new ArrayList());
            }
            case UINTEGER16: {
                return codec.apply(b -> DecodeUtils.uInteger16Type(datagram, b, policy), new ArrayList());
            }
            case UINTEGER32: {
                return codec.apply(b -> DecodeUtils.uInteger32Type(datagram, b, policy), new ArrayList());
            }
            case INTEGER8: {
                return codec.apply(b -> DecodeUtils.integer8Type(datagram, b), new ArrayList());
            }
            case INTEGER16: {
                return codec.apply(b -> DecodeUtils.integer16Type(datagram, b, policy), new ArrayList());
            }
            case FLOAT: {
                return codec.apply(b -> Float.valueOf(DecodeUtils.floatType(datagram, b, policy)), new ArrayList());
            }
            case DOUBLE: {
                return codec.apply(b -> DecodeUtils.doubleType(datagram, b, policy), new ArrayList());
            }
        }
        throw new DecodeException(MessageFormat.format(CodecError.NOT_SUPPORT_ARRAY_TYPE.getMessage(), type.toString()));
    }
}

