/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.encoder;

import org.indunet.fastproto.EndianPolicy;
import org.indunet.fastproto.annotation.type.CharacterType;
import org.indunet.fastproto.encoder.EncodeContext;
import org.indunet.fastproto.encoder.TypeEncoder;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.exception.EncodeException;
import org.indunet.fastproto.exception.SpaceNotEnoughException;
import org.indunet.fastproto.util.ReverseUtils;

public class CharacterEncoder
implements TypeEncoder {
    @Override
    public void encode(EncodeContext context) {
        CharacterType type = context.getTypeAnnotation(CharacterType.class);
        Character value = context.getValue(Character.class);
        EndianPolicy policy = context.getEndianPolicy();
        this.encode(context.getDatagram(), type.value(), policy, value.charValue());
    }

    public void encode(byte[] datagram, int byteOffset, EndianPolicy policy, char value) {
        int bo = ReverseUtils.byteOffset(datagram.length, byteOffset);
        if (bo < 0) {
            throw new EncodeException(CodecError.ILLEGAL_BYTE_OFFSET);
        }
        if (bo + 2 > datagram.length) {
            throw new SpaceNotEnoughException(CodecError.EXCEEDED_DATAGRAM_SIZE);
        }
        if (policy == EndianPolicy.BIG) {
            datagram[bo] = (byte)(value >>> 8);
            datagram[bo + 1] = (byte)value;
        } else {
            datagram[bo + 1] = (byte)(value >>> 8);
            datagram[bo] = (byte)value;
        }
    }
}

